/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.datasource.wrapper.AfDataSourceWrapper;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    public static final String DEFAULT_DATASOURCE_NAME = "master";
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDataSource.class);
    private static final ThreadLocal<Deque<String>> LOOKUP_KEY_HOLDER = new NamedThreadLocal<Deque<String>>("dynamic-datasource"){

        protected Deque<String> initialValue() {
            return new ArrayDeque<String>();
        }
    };
    private static Map<String, AfDataSourceWrapper> dataSourceInfo = new HashMap<String, AfDataSourceWrapper>(3);

    public DynamicDataSource(DataSource dataSource, Map<String, AfDataSourceWrapper> dataSources) {
        dataSourceInfo = dataSources;
        HashMap targetDataSourcesMap = new HashMap(dataSources.size());
        dataSources.forEach((key, value) -> targetDataSourcesMap.put(key, value.getDataSource()));
        super.setDefaultTargetDataSource((Object)dataSource);
        super.setTargetDataSources(targetDataSourcesMap);
        super.afterPropertiesSet();
    }

    public DynamicDataSource() {
    }

    public static String getDataSource() {
        return Optional.ofNullable(LOOKUP_KEY_HOLDER.get().peek()).orElse(DEFAULT_DATASOURCE_NAME);
    }

    private static void setDataSource(String dataSource) {
        String dataSourceStr = StringUtils.isEmpty((String)dataSource) ? DEFAULT_DATASOURCE_NAME : dataSource;
        LOOKUP_KEY_HOLDER.get().push(dataSourceStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withDataSource(String dataSource, Supplier<T> supplier) {
        if (dataSource == null) {
            return supplier.get();
        }
        String lastDataSource = LOOKUP_KEY_HOLDER.get().peekLast();
        if (lastDataSource != null && lastDataSource.equals(dataSource)) {
            return supplier.get();
        }
        DynamicDataSource.setDataSource(dataSource);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            DynamicDataSource.pollDataSource();
        }
    }

    public static void withDataSource(String dataSource, Runnable runnable) {
        DynamicDataSource.withDataSource(dataSource, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T withDataSource(String dataSource, Function<JSONObject, T> runnable) {
        return DynamicDataSource.withDataSource(dataSource, runnable, null);
    }

    public static <T> T withDataSource(String dataSource, Function<JSONObject, T> runnable, JSONObject params) {
        return (T)DynamicDataSource.withDataSource(dataSource, () -> runnable.apply(params));
    }

    private static void pollDataSource() {
        Deque<String> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            DynamicDataSource.clearDataSource();
        }
    }

    public static void clearDataSource() {
        LOOKUP_KEY_HOLDER.remove();
    }

    public static Map<String, AfDataSourceWrapper> getDataSourceMap() {
        return dataSourceInfo;
    }

    public static AfDataSourceWrapper getWrapper() {
        String dataSource = DynamicDataSource.getDataSource();
        AfDataSourceWrapper wrapper = DynamicDataSource.getDataSourceMap().get(dataSource);
        if (wrapper == null) {
            LOGGER.error("\u4e0d\u5b58\u5728\u7684\u6570\u636e\u6e90\uff1a{}", (Object)dataSource);
            throw new ServiceException("\u4e0d\u5b58\u5728\u7684\u6570\u636e\u6e90", Integer.valueOf(500));
        }
        return DynamicDataSource.getDataSourceMap().get(DynamicDataSource.getDataSource());
    }

    public static DbType getDbType() {
        return DynamicDataSource.getWrapper().getDbType();
    }

    protected Object determineCurrentLookupKey() {
        return DynamicDataSource.getDataSource();
    }
}

