/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.DialectException;
import com.af.v4.system.common.datasource.dialects.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectFunctionUtils {
    private static final Logger logger = LoggerFactory.getLogger(DialectFunctionUtils.class);

    protected static String render(Dialect d, String functionName, String ... args) {
        String searchStr;
        char c;
        Object template = d.functions.get(functionName.toLowerCase());
        if (template == null || ((String)template).isEmpty()) {
            template = "*";
        }
        if ("*".equals(template)) {
            template = functionName + "($Params)";
        }
        if ((c = ((String)template).charAt(1)) != '=') {
            if (((String)template).contains("$Params")) {
                return StrUtils.replace((String)template, "$Params", StrUtils.arrayToString(args, ", "));
            }
            if (((String)template).contains("$Compact_Params")) {
                return StrUtils.replace((String)template, "$Compact_Params", StrUtils.arrayToString(args, ","));
            }
            if (((String)template).contains("$Lined_Params")) {
                return StrUtils.replace((String)template, "$Lined_Params", StrUtils.arrayToString(args, "||"));
            }
            if (((String)template).contains("$Add_Params")) {
                return StrUtils.replace((String)template, "$Add_Params", StrUtils.arrayToString(args, "+"));
            }
            if (((String)template).contains("$IN_Params")) {
                return StrUtils.replace((String)template, "$IN_Params", StrUtils.arrayToString(args, " in "));
            }
            if (((String)template).contains("$Pattern_Params")) {
                return StrUtils.replace((String)template, "$Pattern_Params", StrUtils.arrayToString(args, "%pattern"));
            }
            if (((String)template).contains("$Startswith_Params")) {
                return StrUtils.replace((String)template, "$Startswith_Params", StrUtils.arrayToString(args, "%startswith"));
            }
            if (((String)template).contains("$DelFunc")) {
                return StrUtils.replace((String)template, "$DelFunc", "");
            }
            if (((String)template).contains("$CONVERT")) {
                return StrUtils.sqlServerConvertTran(d, args);
            }
            if (((String)template).contains("$CAST")) {
                return StrUtils.sqlServerCastTran(d, args);
            }
            if (((String)template).contains("$DATEDIFF")) {
                return StrUtils.sqlServerDATEDIFFTran(d, args);
            }
            if (((String)template).contains("$NVL_Params")) {
                if (args == null || args.length < 2) {
                    DialectException.throwEX("Nvl function require at least 2 parameters");
                } else {
                    StringBuilder s = new StringBuilder("nvl(" + args[args.length - 2] + ", " + args[args.length - 1] + ")");
                    for (int i = args.length - 3; i > -1; --i) {
                        s = new StringBuilder("nvl(" + args[i] + ", " + String.valueOf(s) + ")");
                    }
                    return StrUtils.replace((String)template, "$NVL_Params", s.toString());
                }
            }
            return (String)DialectException.throwEX("jDialect found a template bug error, please submit this bug");
        }
        int argsCount = 0;
        if (args != null) {
            argsCount = args.length;
        }
        if (!((String)template).contains(searchStr = argsCount + "=")) {
            logger.warn("Dialect {}'s function \"{}\" only support {} parameters", new Object[]{d, functionName, DialectFunctionUtils.allowedParameterQTY((String)template)});
        }
        String result = StrUtils.substringBetween((String)template + "|", searchStr, "|");
        for (int i = 0; args != null && i < args.length; ++i) {
            result = StrUtils.replace(result, "$P" + (i + 1), args[i]);
        }
        return result;
    }

    private static String allowedParameterQTY(String template) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            if (!template.contains(i + "=")) continue;
            sb.append(i).append(" or ");
        }
        if (!sb.isEmpty()) {
            sb.setLength(sb.length() - 4);
        }
        return sb.toString();
    }
}

