/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.DialectException;
import com.af.v4.system.common.datasource.dialects.JdbcUtil;
import com.af.v4.system.common.datasource.dialects.StrUtils;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;
import com.af.v4.system.common.datasource.dialects.id.IdGenerator;
import java.sql.Connection;

public class SequenceIdGenerator
implements IdGenerator {
    private String name;
    private String sequenceName;
    private Integer initialValue = 0;
    private Integer allocationSize = 1;

    public SequenceIdGenerator(String name, String sequenceName, Integer initialValue, Integer allocationSize) {
        this.name = name;
        this.sequenceName = sequenceName;
        this.initialValue = initialValue;
        this.allocationSize = allocationSize;
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        DialectException.assureNotEmpty(this.sequenceName, "sequenceName can not be empty");
        String sequenctSQL = dialect.ddlFeatures.getSequenceNextValString();
        sequenctSQL = StrUtils.replace(sequenctSQL, "_SEQNAME", this.sequenceName);
        return JdbcUtil.qryOneObject(con, sequenctSQL, new Object[0]);
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.SEQUENCE;
    }

    @Override
    public String getIdGenName() {
        return this.name;
    }

    @Override
    public IdGenerator newCopy() {
        return new SequenceIdGenerator(this.name, this.sequenceName, this.initialValue, this.allocationSize);
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public Integer getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Integer initialValue) {
        this.initialValue = initialValue;
    }

    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    public void setAllocationSize(Integer allocationSize) {
        this.allocationSize = allocationSize;
    }
}

