/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.config;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.enums.DbType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfDataSourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AfDataSourceConfig.class);
    private String name;
    private String redirect;
    private String driverClassName;
    private DbType type;
    private String url;
    private String username;
    private String password;
    private String dialect;
    private List<String> cfgLocations;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        LOGGER.warn("\u6784\u5efa\u6570\u636e\u6e90\u65f6\u53d1\u73b0\u8fc7\u65f6\u7684\u6570\u636e\u6e90\u53c2\u6570\uff1a[driverClassName]\uff0c\u8bf7\u4f7f\u7528\u53c2\u6570\uff1a[type]\u66ff\u4ee3");
        DbType dbType = DbType.ofByDriverClassName(driverClassName);
        if (dbType == null) {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u9a71\u52a8\uff1a" + driverClassName);
        }
        this.driverClassName = driverClassName;
        this.type = dbType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public List<String> getCfgLocations() {
        return this.cfgLocations;
    }

    public void setCfgLocations(List<String> cfgLocations) {
        this.cfgLocations = cfgLocations;
    }

    public DbType getType() {
        return this.type;
    }

    public void setType(String type) {
        DbType dbType = DbType.of(type.toLowerCase());
        if (dbType == null) {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + type);
        }
        this.driverClassName = dbType.driverClassName;
        this.type = dbType;
    }
}

