package com.af.v4.system.common.datasource.provider;

import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;

import java.util.Objects;

/**
 * 数据源创建器
 */
public class DataSourceProvider {

    private final static int DEFAULT_MAX_ACTIVE_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;

    public static HikariDataSource create(AfDataSourceConfig config, Integer minimumIdle, Integer maximumPoolSize, Integer connectionTimeout,
                                          Integer idleTimeout, Integer maxLifetime) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName(config.getName());
        hikariConfig.setDriverClassName(config.getDriverClassName());
        hikariConfig.setJdbcUrl(config.getUrl());
        hikariConfig.setUsername(config.getUsername());
        hikariConfig.setPassword(config.getPassword());
        hikariConfig.setMinimumIdle(Objects.requireNonNullElse(minimumIdle, DEFAULT_MAX_ACTIVE_SIZE));
        hikariConfig.setMaximumPoolSize(Objects.requireNonNullElse(maximumPoolSize, DEFAULT_MAX_ACTIVE_SIZE));
        hikariConfig.setConnectionTimeout(Objects.requireNonNullElse(connectionTimeout, 30000));
        hikariConfig.setIdleTimeout(Objects.requireNonNullElse(idleTimeout, 30000));
        hikariConfig.setMaxLifetime(Objects.requireNonNullElse(maxLifetime, 180000));
        return new HikariDataSource(hikariConfig);
    }
}
