/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;
import com.af.v4.system.common.datasource.dialects.id.IdGenerator;
import java.security.SecureRandom;
import java.sql.Connection;

public class UUIDAnyGenerator
implements IdGenerator {
    private static final SecureRandom random = new SecureRandom();
    private static final char[] ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
    private final String name;
    private Integer length = 36;

    public UUIDAnyGenerator(String name, Integer length) {
        this.name = name;
        this.length = length;
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.UUID_ANY;
    }

    @Override
    public String getIdGenName() {
        return this.name;
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        return UUIDAnyGenerator.getAnyLengthRadix36UUID(this.length);
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return new UUIDAnyGenerator(this.name, this.length);
    }

    public static String getAnyLengthRadix36UUID(Integer length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHABET[random.nextInt(32)]);
        }
        return sb.toString();
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }
}

