/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects;

import com.af.v4.system.common.datasource.dialects.DDLFeatures;
import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.model.ColumnModel;
import com.af.v4.system.common.datasource.dialects.model.FKeyModel;
import com.af.v4.system.common.datasource.dialects.model.TableModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class DebugUtils {
    public static String getColumnModelDebugInfo(ColumnModel c) {
        StringBuilder sb = new StringBuilder();
        sb.append("columnName=").append(c.getColumnName()).append(", ");
        sb.append("transient=").append(c.getTransientable()).append(", ");
        sb.append("columnType=").append((Object)c.getColumnType()).append(", ");
        sb.append("columnDefinition=").append(c.getColumnDefinition()).append(", ");
        sb.append("pkey=").append(c.getPkey()).append(", ");
        if (c.getShardTable() != null) {
            sb.append("shardTable=").append(Arrays.deepToString(c.getShardTable())).append(", ");
        } else {
            sb.append("shardTable=null").append(", ");
        }
        if (c.getShardDatabase() != null) {
            sb.append("shardDatabase=").append(Arrays.deepToString(c.getShardDatabase())).append(", ");
        } else {
            sb.append("shardDatabase=null").append(", ");
        }
        sb.append("idGenerationType=").append((Object)c.getIdGenerationType()).append(", ");
        sb.append("idGeneratorName=").append(c.getIdGeneratorName()).append(", ");
        sb.append("idGenerator=").append(c.getIdGenerator()).append(", ");
        sb.append("converterClassOrName=").append(c.getConverterClassOrName()).append(", ");
        sb.append("entityField=").append(c.getEntityField()).append(", ");
        sb.append("length=").append(c.getLength()).append(", ");
        sb.append("precisio=").append(c.getPrecision()).append(", ");
        sb.append("scale").append(c.getScale()).append(", ");
        sb.append("valueExist=").append(c.getValueExist()).append(", ");
        sb.append("value=").append(c.getValue()).append(", ");
        sb.append("createTimestamp=").append(c.isCreateTimestamp()).append(", ");
        sb.append("updateTimestamp=").append(c.isUpdateTimestamp()).append(", ");
        sb.append("createdBy=").append(c.isCreatedBy()).append(", ");
        sb.append("lastModifiedBy=").append(c.isLastModifiedBy()).append(", ");
        return sb.toString();
    }

    public static String getFkeyDebugInfo(TableModel t) {
        StringBuilder sb = new StringBuilder();
        sb.append("Fkeys:\r\n");
        for (FKeyModel k : t.getFkeyConstraints()) {
            sb.append("FkeyName=").append(k.getFkeyName());
            sb.append(", ColumnNames=").append(k.getColumnNames());
            sb.append(", RefTableAndColumns=").append(Arrays.deepToString(k.getRefTableAndColumns()));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String getTableModelDebugInfo(TableModel model) {
        StringBuilder sb = new StringBuilder("\r\n=======================================================\r\n");
        sb.append("tableName=").append(model.getTableName()).append("\r\n");
        sb.append("entityClass=").append(model.getEntityClass()).append("\r\n");
        sb.append("readOnly=").append(model.getReadOnly()).append("\r\n");
        sb.append(DebugUtils.getFkeyDebugInfo(model));
        List<ColumnModel> columns = model.getColumns();
        sb.append("Columns:\r\n");
        for (ColumnModel column : columns) {
            sb.append(DebugUtils.getColumnModelDebugInfo(column)).append("\r\n");
        }
        return sb.toString();
    }

    public static String getTableModelsDebugInfo(TableModel[] models) {
        StringBuilder sb = new StringBuilder();
        for (TableModel model : models) {
            sb.append(DebugUtils.getTableModelDebugInfo(model));
        }
        return sb.toString();
    }

    public static String getDialectFullInfo(Dialect d) {
        Object s = "\r\n\r\n=======Dialect Debug Info======\r\n";
        String r = "\r\n";
        DDLFeatures l = d.ddlFeatures;
        s = (String)s + "name=" + d.getName() + r;
        s = (String)s + "===== Dialect pagination templates =====" + r;
        s = (String)s + "sqlTemplate=" + d.sqlTemplate + r;
        s = (String)s + "topLimitTemplate=" + d.topLimitTemplate + r;
        s = (String)s + "===== Dialect DDL feature templates =====" + r;
        s = (String)s + "addColumnString=" + l.addColumnString + r;
        s = (String)s + "addColumnSuffixString=" + l.addColumnSuffixString + r;
        s = (String)s + "addForeignKeyConstraintString=" + l.addForeignKeyConstraintString + r;
        s = (String)s + "addFKeyRefPkeyString=" + l.addFKeyRefPkeyString + r;
        s = (String)s + "addPrimaryKeyConstraintString=" + l.addPrimaryKeyConstraintString + r;
        s = (String)s + "columnComment=" + l.columnComment + r;
        s = (String)s + "createCatalogCommand=" + l.createCatalogCommand + r;
        s = (String)s + "createMultisetTableString=" + l.createMultisetTableString + r;
        s = (String)s + "createPooledSequenceStrings=" + l.createPooledSequenceStrings + r;
        s = (String)s + "createSchemaCommand=" + l.createSchemaCommand + r;
        s = (String)s + "createSequenceStrings=" + l.createSequenceStrings + r;
        s = (String)s + "createTableString=" + l.createTableString + r;
        s = (String)s + "currentSchemaCommand=" + l.currentSchemaCommand + r;
        s = (String)s + "dropCatalogCommand=" + l.dropCatalogCommand + r;
        s = (String)s + "dropForeignKeyString=" + l.dropForeignKeyString + r;
        s = (String)s + "dropSchemaCommand=" + l.dropSchemaCommand + r;
        s = (String)s + "dropSequenceStrings=" + l.dropSequenceStrings + r;
        s = (String)s + "dropTableString=" + l.dropTableString + r;
        s = (String)s + "hasAlterTable=" + l.hasAlterTable + r;
        s = (String)s + "hasDataTypeInIdentityColumn=" + l.hasDataTypeInIdentityColumn + r;
        s = (String)s + "identityColumnString=" + l.identityColumnString + r;
        s = (String)s + "identityColumnStringBigINT=" + l.identityColumnStringBigINT + r;
        s = (String)s + "identitySelectString=" + l.identitySelectString + r;
        s = (String)s + "identitySelectStringBigINT=" + l.identitySelectStringBigINT + r;
        s = (String)s + "needDropConstraintsBeforeDropTable=" + l.needDropConstraintsBeforeDropTable + r;
        s = (String)s + "nullColumnString=" + l.nullColumnString + r;
        s = (String)s + "requiresParensForTupleDistinctCounts=" + l.requiresParensForTupleDistinctCounts + r;
        s = (String)s + "selectSequenceNextValString=" + l.selectSequenceNextValString + r;
        s = (String)s + "sequenceNextValString=" + l.sequenceNextValString + r;
        s = (String)s + "supportsColumnCheck=" + l.supportsColumnCheck + r;
        s = (String)s + "supportsCommentOn=" + l.supportsCommentOn + r;
        s = (String)s + "supportsIdentityColumns=" + l.supportsIdentityColumns + r;
        s = (String)s + "supportsIfExistsAfterConstraintName=" + l.supportsIfExistsAfterConstraintName + r;
        s = (String)s + "openQuote=" + l.openQuote + r;
        s = (String)s + "closeQuote=" + l.closeQuote + r;
        s = (String)s + "===== Dialect type mapping templates =====" + r;
        Map<Type, String> t = d.typeMappings;
        for (Type p : t.keySet()) {
            s = (String)s + String.valueOf((Object)p) + "=" + t.get((Object)p) + r;
        }
        s = (String)s + "===== Dialect function templates =====" + r;
        Map<String, String> f = d.functions;
        for (String fn : f.keySet()) {
            s = (String)s + fn + "=" + f.get(fn) + r;
        }
        s = (String)s + "======================================";
        return s;
    }
}

