/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects.id;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public class SnowflakeCreator {
    private long datacenterIdBits = 5L;
    private long workerIdBits = 5L;
    private final long datacenterId;
    private final long workerId;
    private long maxDatacenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.datacenterIdBits;
    private long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    private final long unusedBits = 1L;
    private final long timestampBits = 41L;
    private final long sequenceBits = 12L;
    private final long maxSequence = 4095L;
    private final long timestampShift = 12L + this.datacenterIdBits + this.workerIdBits;
    private final long datacenterIdShift = 12L + this.workerIdBits;
    private final long workerIdShift = 12L;
    private final long epoch = 1451606400000L;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private final AtomicLong waitCount = new AtomicLong(0L);

    public synchronized long nextId() {
        long currTimestamp = this.timestampGen();
        if (currTimestamp < this.lastTimestamp) {
            throw new IllegalStateException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - currTimestamp));
        }
        if (currTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currTimestamp = this.waitNextMillis(currTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currTimestamp;
        return currTimestamp - 1451606400000L << (int)this.timestampShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << 12 | this.sequence;
    }

    public SnowflakeCreator(long datacenterIdBits, long workerIdBits, long datacenterId, long workerId) {
        this.datacenterIdBits = datacenterIdBits;
        this.workerIdBits = workerIdBits;
        this.maxDatacenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)datacenterIdBits;
        this.maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)workerIdBits;
        if (datacenterId > this.maxDatacenterId || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", this.maxDatacenterId));
        }
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        this.datacenterId = datacenterId;
        this.workerId = workerId;
    }

    public long getWaitCount() {
        return this.waitCount.get();
    }

    protected long waitNextMillis(long currTimestamp) {
        this.waitCount.incrementAndGet();
        while (currTimestamp <= this.lastTimestamp) {
            currTimestamp = this.timestampGen();
        }
        return currTimestamp;
    }

    protected long timestampGen() {
        return System.currentTimeMillis();
    }

    public String toString() {
        return "Snowflake Settings [timestampBits=41, datacenterIdBits=" + this.datacenterIdBits + ", workerIdBits=" + this.workerIdBits + ", sequenceBits=12, epoch=1451606400000, datacenterId=" + this.datacenterId + ", workerId=" + this.workerId + "]";
    }

    public long getEpoch() {
        return this.epoch;
    }

    public long[] parseId(long id) {
        long[] arr = new long[5];
        arr[4] = (id & this.diode(1L, 41L)) >> (int)this.timestampShift;
        arr[0] = arr[4] + 1451606400000L;
        arr[1] = (id & this.diode(42L, this.datacenterIdBits)) >> (int)this.datacenterIdShift;
        arr[2] = (id & this.diode(42L + this.datacenterIdBits, this.workerIdBits)) >> 12;
        arr[3] = id & this.diode(42L + this.datacenterIdBits + this.workerIdBits, 12L);
        return arr;
    }

    public String formatId(long id) {
        long[] arr = this.parseId(id);
        String tmf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(arr[0]));
        return String.format("%s, #%d, @(%d,%d)", tmf, arr[3], arr[1], arr[2]);
    }

    private long diode(long offset, long length) {
        int lb = (int)(64L - offset);
        int rb = (int)(64L - (offset + length));
        return -1L << lb ^ -1L << rb;
    }
}

