package com.af.v4.system.common.datasource.wrapper;

import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.af.v4.system.common.datasource.enums.DbType;
import com.zaxxer.hikari.HikariDataSource;

/**
 * 数据源扩展
 */
public class AfDataSourceWrapper {
    private final HikariDataSource ds;
    private final AfDataSourceConfig config;

    public AfDataSourceWrapper(HikariDataSource ds, AfDataSourceConfig config) {
        this.ds = ds;
        this.config = config;
    }

    public DbType getDbType() {
        return config.getType();
    }

    public HikariDataSource getDataSource() {
        return ds;
    }

    public AfDataSourceConfig getConfig() {
        return config;
    }
}
