package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;

import java.sql.Connection;
import java.util.UUID;

/**
 * Generate a JDK 32 letters random UUID based on Base16 encoding, example:
 * bca5414e9b1b4bdfa257125e05428b92
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class UUID32Generator implements IdGenerator {
    public static final UUID32Generator INSTANCE = new UUID32Generator();

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.UUID32;
    }

    @Override
    public String getIdGenName() {
        return "UUID32";
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        return getUUID32();
    }

    public static String getUUID32() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }
}
