package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.StrUtils;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;

import java.math.BigInteger;
import java.sql.Connection;
import java.util.UUID;

/**
 * Compress JDK UUID to 26 letters based on radix 36, use 0-9 a-z characters,
 * example: pbicz3grgu0zk3ipe1yur03h7a
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class UUID26Generator implements IdGenerator {
    public static final UUID26Generator INSTANCE = new UUID26Generator();

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.UUID26;
    }

    @Override
    public String getIdGenName() {
        return "UUID26";
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        return getUUID26();
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }

    public static String getUUID26() {
        String uuidHex = UUID.randomUUID().toString().replace("-", "");
        BigInteger b = new BigInteger(uuidHex, 16);
        StringBuilder s = new StringBuilder(b.toString(36));
        while (s.length() < 26)
            s.append(StrUtils.getRandomChar());
        return s.toString();
    }

}
