/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.enums;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.utils.FnvHash;
import com.clickhouse.jdbc.ClickHouseDriver;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.mysql.cj.jdbc.Driver;
import dm.jdbc.driver.DmDriver;
import oracle.jdbc.OracleDriver;

public enum DbType {
    postgresql(16L, org.postgresql.Driver.class.getCanonicalName(), Dialect.PostgreSQLDialect),
    sqlserver(32L, SQLServerDriver.class.getCanonicalName(), Dialect.SQLServerDialect),
    oracle(64L, OracleDriver.class.getCanonicalName(), Dialect.OracleDialect),
    mysql(128L, Driver.class.getCanonicalName(), Dialect.MySQLDialect),
    dm(4096L, DmDriver.class.getCanonicalName(), Dialect.DamengDialect),
    clickhouse(0x10000000L, ClickHouseDriver.class.getCanonicalName(), Dialect.ClickhouseDialect),
    doris(0x100000000000L, Driver.class.getCanonicalName(), Dialect.MySQLDialect),
    opengauss(0x200000000000L, org.opengauss.Driver.class.getCanonicalName(), Dialect.PostgreSQLDialect);

    public final long mask;
    public final String driverClassName;
    public final long hashCode64;
    public final Dialect dialect;

    private DbType(long mask, String driverClassName, Dialect dialect) {
        this.mask = mask;
        this.driverClassName = driverClassName;
        this.dialect = dialect;
        this.hashCode64 = FnvHash.hashCode64(this.name());
    }

    public static long of(DbType ... types) {
        long value = 0L;
        for (DbType type : types) {
            value |= type.mask;
        }
        return value;
    }

    public static DbType of(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        try {
            return DbType.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DbType ofByDriverClassName(String driverClassName) {
        if (driverClassName == null || driverClassName.isEmpty()) {
            return null;
        }
        for (DbType type : DbType.values()) {
            if (!type.driverClassName.equals(driverClassName)) continue;
            return type;
        }
        return null;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public final boolean equals(String other) {
        return this == DbType.of(other);
    }
}

