/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects;

import com.af.v4.system.common.datasource.dialects.DDLFeatures;
import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.model.ColumnModel;
import com.af.v4.system.common.datasource.dialects.model.FKeyModel;
import com.af.v4.system.common.datasource.dialects.model.TableModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class DebugUtils {
    public static String getColumnModelDebugInfo(ColumnModel c) {
        StringBuilder sb = new StringBuilder();
        sb.append("columnName=").append(c.getColumnName()).append(", ");
        sb.append("transient=").append(c.getTransientable()).append(", ");
        sb.append("columnType=").append((Object)c.getColumnType()).append(", ");
        sb.append("columnDefinition=").append(c.getColumnDefinition()).append(", ");
        sb.append("pkey=").append(c.getPkey()).append(", ");
        if (c.getShardTable() != null) {
            sb.append("shardTable=").append(Arrays.deepToString(c.getShardTable())).append(", ");
        } else {
            sb.append("shardTable=null").append(", ");
        }
        if (c.getShardDatabase() != null) {
            sb.append("shardDatabase=").append(Arrays.deepToString(c.getShardDatabase())).append(", ");
        } else {
            sb.append("shardDatabase=null").append(", ");
        }
        sb.append("idGenerationType=").append((Object)c.getIdGenerationType()).append(", ");
        sb.append("idGeneratorName=").append(c.getIdGeneratorName()).append(", ");
        sb.append("idGenerator=").append(c.getIdGenerator()).append(", ");
        sb.append("converterClassOrName=").append(c.getConverterClassOrName()).append(", ");
        sb.append("entityField=").append(c.getEntityField()).append(", ");
        sb.append("length=").append(c.getLength()).append(", ");
        sb.append("precisio=").append(c.getPrecision()).append(", ");
        sb.append("scale").append(c.getScale()).append(", ");
        sb.append("valueExist=").append(c.getValueExist()).append(", ");
        sb.append("value=").append(c.getValue()).append(", ");
        sb.append("createTimestamp=").append(c.isCreateTimestamp()).append(", ");
        sb.append("updateTimestamp=").append(c.isUpdateTimestamp()).append(", ");
        sb.append("createdBy=").append(c.isCreatedBy()).append(", ");
        sb.append("lastModifiedBy=").append(c.isLastModifiedBy()).append(", ");
        return sb.toString();
    }

    public static String getFkeyDebugInfo(TableModel t) {
        StringBuilder sb = new StringBuilder();
        sb.append("Fkeys:\r\n");
        for (FKeyModel k : t.getFkeyConstraints()) {
            sb.append("FkeyName=").append(k.getFkeyName());
            sb.append(", ColumnNames=").append(k.getColumnNames());
            sb.append(", RefTableAndColumns=").append(Arrays.deepToString(k.getRefTableAndColumns()));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String getTableModelDebugInfo(TableModel model) {
        StringBuilder sb = new StringBuilder("\r\n=======================================================\r\n");
        sb.append("tableName=").append(model.getTableName()).append("\r\n");
        sb.append("entityClass=").append(model.getEntityClass()).append("\r\n");
        sb.append("readOnly=").append(model.getReadOnly()).append("\r\n");
        sb.append(DebugUtils.getFkeyDebugInfo(model));
        List<ColumnModel> columns = model.getColumns();
        sb.append("Columns:\r\n");
        for (ColumnModel column : columns) {
            sb.append(DebugUtils.getColumnModelDebugInfo(column)).append("\r\n");
        }
        return sb.toString();
    }

    public static String getTableModelsDebugInfo(TableModel[] models) {
        StringBuilder sb = new StringBuilder();
        for (TableModel model : models) {
            sb.append(DebugUtils.getTableModelDebugInfo(model));
        }
        return sb.toString();
    }

    public static String getDialectFullInfo(Dialect d) {
        StringBuilder s = new StringBuilder("\r\n\r\n=======Dialect Debug Info======\r\n");
        String r = "\r\n";
        DDLFeatures l = d.ddlFeatures;
        s.append("name=").append(d.getName()).append(r);
        s.append("===== Dialect pagination templates =====").append(r);
        s.append("sqlTemplate=").append(d.sqlTemplate).append(r);
        s.append("topLimitTemplate=").append(d.topLimitTemplate).append(r);
        s.append("===== Dialect DDL feature templates =====").append(r);
        s.append("addColumnString=").append(l.addColumnString).append(r);
        s.append("addColumnSuffixString=").append(l.addColumnSuffixString).append(r);
        s.append("addForeignKeyConstraintString=").append(l.addForeignKeyConstraintString).append(r);
        s.append("addFKeyRefPkeyString=").append(l.addFKeyRefPkeyString).append(r);
        s.append("addPrimaryKeyConstraintString=").append(l.addPrimaryKeyConstraintString).append(r);
        s.append("columnComment=").append(l.columnComment).append(r);
        s.append("createCatalogCommand=").append(l.createCatalogCommand).append(r);
        s.append("createMultisetTableString=").append(l.createMultisetTableString).append(r);
        s.append("createPooledSequenceStrings=").append(l.createPooledSequenceStrings).append(r);
        s.append("createSchemaCommand=").append(l.createSchemaCommand).append(r);
        s.append("createSequenceStrings=").append(l.createSequenceStrings).append(r);
        s.append("createTableString=").append(l.createTableString).append(r);
        s.append("currentSchemaCommand=").append(l.currentSchemaCommand).append(r);
        s.append("dropCatalogCommand=").append(l.dropCatalogCommand).append(r);
        s.append("dropForeignKeyString=").append(l.dropForeignKeyString).append(r);
        s.append("dropSchemaCommand=").append(l.dropSchemaCommand).append(r);
        s.append("dropSequenceStrings=").append(l.dropSequenceStrings).append(r);
        s.append("dropTableString=").append(l.dropTableString).append(r);
        s.append("hasAlterTable=").append(l.hasAlterTable).append(r);
        s.append("hasDataTypeInIdentityColumn=").append(l.hasDataTypeInIdentityColumn).append(r);
        s.append("identityColumnString=").append(l.identityColumnString).append(r);
        s.append("identityColumnStringBigINT=").append(l.identityColumnStringBigINT).append(r);
        s.append("identitySelectString=").append(l.identitySelectString).append(r);
        s.append("identitySelectStringBigINT=").append(l.identitySelectStringBigINT).append(r);
        s.append("needDropConstraintsBeforeDropTable=").append(l.needDropConstraintsBeforeDropTable).append(r);
        s.append("nullColumnString=").append(l.nullColumnString).append(r);
        s.append("requiresParensForTupleDistinctCounts=").append(l.requiresParensForTupleDistinctCounts).append(r);
        s.append("selectSequenceNextValString=").append(l.selectSequenceNextValString).append(r);
        s.append("sequenceNextValString=").append(l.sequenceNextValString).append(r);
        s.append("supportsColumnCheck=").append(l.supportsColumnCheck).append(r);
        s.append("supportsCommentOn=").append(l.supportsCommentOn).append(r);
        s.append("supportsIdentityColumns=").append(l.supportsIdentityColumns).append(r);
        s.append("supportsIfExistsAfterConstraintName=").append(l.supportsIfExistsAfterConstraintName).append(r);
        s.append("openQuote=").append(l.openQuote).append(r);
        s.append("closeQuote=").append(l.closeQuote).append(r);
        s.append("===== Dialect type mapping templates =====").append(r);
        Map<Type, String> t = d.typeMappings;
        for (Type p : t.keySet()) {
            s.append((Object)p).append("=").append(t.get((Object)p)).append(r);
        }
        s.append("===== Dialect function templates =====").append(r);
        Map<String, String> f = d.functions;
        for (String fn : f.keySet()) {
            s.append(fn).append("=").append(f.get(fn)).append(r);
        }
        s.append("======================================");
        return s.toString();
    }
}

