package com.af.v4.system.common.datasource.dialects;


/**
 * Virtual SQL Type definitions
 *
 * @since 1.0.0
 */
public enum Type {
    BIGINT, BINARY, BIT, BLOB, BOOLEAN, CHAR, CLOB, DATE, DECIMAL, DOUBLE, FLOAT, INTEGER, JAVA_OBJECT, LONGNVARCHAR, LONGVARBINARY, LONGVARCHAR, NCHAR, NCLOB, NUMERIC, NVARCHAR, UNKNOW, REAL, SMALLINT, TIME, TIMESTAMP, TINYINT, VARBINARY, VARCHAR
    //mysql
    , DATETIME, MEDIUMINT, INT, TINYBLOB, TINYTEXT, TEXT, MEDIUMBLOB, MEDIUMTEXT, LONGBLOB, LONGTEXT, YEAR, JSON
    //oracle
    , BINARY_FLOAT, DOUBLE_PRECISION, BINARY_DOUBLE, TIMESTAMP_WITH_TIME_ZONE, TIMESTAMP_WITH_LOCAL_TIME_ZONE, VARCHAR2, INTERVAL_YEAR_TO_MONTH, INTERVAL_DAY_TO_SECOND;

    //TODO 此处需要考虑数据类型多对一的情况
    public static Type getByTypeName(String typeName) {
        for (Type val : Type.values()) {
            if (val.name().equalsIgnoreCase(typeName)) {
                return val;
            }
        }
        throw new DialectException(STR."'\{typeName}' can not be map to a dialect type");
    }

}
