package com.af.v4.system.common.datasource.dialects;

import java.util.Map;

/**
 * Function templates, this file not include some not common functions (<15% percent dialects support)
 *
 * @since 1.0.1
 */
@SuppressWarnings("all")
public class DialectFunctionTemplate {

    /**
     * Initialize extra function templates
     */
    protected static void initExtraFunctionTemplates() {
        for (Dialect d : Dialect.dialects) //register quote function for all dialects, qt是一个引用符函数
            DialectFunctionTemplate.registerFunction("qt", "1=" + d.ddlFeatures.getOpenQuote() + "$P1" + d.ddlFeatures.getCloseQuote(), d);
        registerFunction("regexlike", "2=$P1 regexp $P2", "MySQL", "H2"); //register regexlike function 给个别方言添加正则查询函数
        registerFunction("regexlike", "2=regex_like($P1, $P2)", "Oracle");

        // 添加注释处理函数，支持所有方言
        registerFunction("--", "0=--", "PostgreSQL", "Oracle", "SQLServer", "MySQL");
        registerFunction("/*", "0=/*", "PostgreSQL", "Oracle", "SQLServer", "MySQL");
        registerFunction("*/", "0=*/", "PostgreSQL", "Oracle", "SQLServer", "MySQL");
        registerFunction("##", "0=--", "PostgreSQL", "Oracle", "SQLServer");

        // 跨数据库常用的字符串处理函数
        registerFunction("concat_ws", "2=concat_ws($P1, $P2)", "MySQL");
        registerFunction("concat_ws", "2=string_agg($P2, $P1)", "PostgreSQL");
        registerFunction("concat_ws", "3=CASE WHEN $P3 IS NULL THEN $P2 ELSE $P2 || $P1 || $P3 END", "Oracle");
        registerFunction("concat_ws", "3=CASE WHEN $P3 IS NULL THEN $P2 ELSE $P2 + $P1 + $P3 END", "SQLServer");

        registerFunction("left", "2=left($P1, $P2)", "MySQL", "PostgreSQL", "SQLServer");
        registerFunction("left", "2=substr($P1, 1, $P2)", "Oracle");

        registerFunction("right", "2=right($P1, $P2)", "MySQL", "PostgreSQL", "SQLServer");
        registerFunction("right", "2=substr($P1, -$P2)", "Oracle");

        registerFunction("repeat", "2=repeat($P1, $P2)", "MySQL", "PostgreSQL");
        registerFunction("repeat", "2=rpad('', $P2, $P1)", "Oracle");
        registerFunction("repeat", "2=replicate($P1, $P2)", "SQLServer");

        // 跨数据库常用的日期时间函数
        registerFunction("date_format", "2=to_char($P1, $P2)", "PostgreSQL", "Oracle");
        registerFunction("date_format", "2=format($P1, $P2)", "SQLServer");

        registerFunction("str_to_date", "2=to_date($P1, $P2)", "Oracle");
        registerFunction("str_to_date", "2=to_timestamp($P1, $P2)", "PostgreSQL");
        registerFunction("str_to_date", "2=convert(datetime, $P1, $P2)", "SQLServer");

        // 跨数据库常用的条件表达式函数
        registerFunction("if", "3=CASE WHEN $P1 THEN $P2 ELSE $P3 END", "PostgreSQL", "Oracle", "SQLServer");
        registerFunction("ifnull", "2=coalesce($P1, $P2)", "PostgreSQL", "SQLServer");
        registerFunction("ifnull", "2=nvl($P1, $P2)", "Oracle");

        registerFunction("isnull", "2=ifnull($P1, $P2)", "MySQL");
        registerFunction("isnull", "2=coalesce($P1, $P2)", "PostgreSQL", "Oracle");

        // 常用函数的跨数据库映射
        registerFunction("add_months", "2=DATE_ADD($P1, INTERVAL $P2 MONTH)", "MySQL");
        registerFunction("add_months", "2=DATEADD(month, $P2, $P1)", "SQLServer");
        registerFunction("add_months", "2=($P1 + interval '$P2 month')", "PostgreSQL");

        registerFunction("dateadd", "3=DATE_ADD($P3, INTERVAL $P2 $P1)", "MySQL");
        registerFunction("dateadd", "3=($P3 + INTERVAL '$P2 $P1')", "PostgreSQL");
        registerFunction("dateadd", "3=CASE WHEN $P1 = 'year' THEN ADD_MONTHS($P3, $P2 * 12) WHEN $P1 = 'month' THEN ADD_MONTHS($P3, $P2) WHEN $P1 = 'day' THEN $P3 + $P2 WHEN $P1 = 'hour' THEN $P3 + $P2/24 WHEN $P1 = 'minute' THEN $P3 + $P2/1440 WHEN $P1 = 'second' THEN $P3 + $P2/86400 ELSE $P3 END", "Oracle");

        // DATE_SUB函数处理
        registerFunction("date_sub", "3=DATE_SUB($P1, INTERVAL $P2 $P3)", "MySQL");
        registerFunction("date_sub", "3=($P1 - INTERVAL '$P2 $P3')", "PostgreSQL");
        registerFunction("date_sub", "3=CASE WHEN $P3 = 'year' THEN ADD_MONTHS($P1, -$P2 * 12) WHEN $P3 = 'month' THEN ADD_MONTHS($P1, -$P2) WHEN $P3 = 'day' THEN $P1 - $P2 WHEN $P3 = 'hour' THEN $P1 - $P2/24 WHEN $P3 = 'minute' THEN $P1 - $P2/1440 WHEN $P3 = 'second' THEN $P1 - $P2/86400 ELSE $P1 END", "Oracle");
        registerFunction("date_sub", "3=DATEADD($P3, -$P2, $P1)", "SQLServer");

        // 组合聚合函数映射
        registerFunction("group_concat", "1=string_agg($P1, ',')", "PostgreSQL");
        registerFunction("group_concat", "1=listagg($P1, ',')", "Oracle");
        registerFunction("group_concat", "1=string_agg($P1, ',')", "SQLServer");

        registerFunction("listagg", "2=string_agg($P1, $P2)", "PostgreSQL");
        registerFunction("listagg", "2=group_concat($P1 SEPARATOR $P2)", "MySQL");
        registerFunction("listagg", "2=string_agg($P1, $P2)", "SQLServer");
    }

    /**
     * @param databaseFamily
     * @param function
     * @param template
     */
    public static void registerFunction(String function, String template, String... databaseFamily) {
        DialectFunctionTranslator.instance.getFunctionMap().put(function.toUpperCase(), 0);
        for (Dialect dialect : Dialect.dialects) {
            for (String family : databaseFamily) {
                if (dialect.isFamily(family)) {
                    dialect.functions.put(function, template);
                }
            }
        }
    }

    public static void registerFunction(String function, String template, Dialect... dialects) {
        DialectFunctionTranslator.instance.getFunctionMap().put(function.toUpperCase(), 0);
        for (Dialect dialect : Dialect.dialects) {
            for (Dialect d : dialects) {
                if (dialect == d)
                    dialect.functions.put(function, template);
            }
        }
    }

    protected static void initFunctionTemplates() {

        //================SQLiteDialect family===============
        Map<String, String> m = Dialect.SQLiteDialect.functions;
        m.put("abs", "*");
        m.put("avg", "1=avg($P1)");
        m.put("bit_length", "*");
        m.put("cast", "1=cast($P1)|2=cast($P1 as $P2)");
        m.put("coalesce", "*");
        m.put("concat", "$Lined_Params");
        m.put("count", "*");
        m.put("day", "1=extract(day from $P1)");
        m.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        m.put("hour", "1=extract(hour from $P1)");
        m.put("length", "*");
        m.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        m.put("lower", "*");
        m.put("max", "*");
        m.put("min", "*");
        m.put("minute", "1=extract(minute from $P1)");
        m.put("mod", "1=$P1|2=$P1 % $P2");
        m.put("month", "1=extract(month from $P1)");
        m.put("nullif", "*");
        m.put("quote", "*");
        m.put("random", "0=random()");
        m.put("round", "*");
        m.put("second", "1=extract(second from $P1)");
        m.put("sqrt", "*");
        m.put("str", "1=cast($P1 as char)");
        m.put("substr", "*");
        m.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        m.put("sum", "*");
        m.put("trim", "1=trim($P1)|2=trim($P2, $P1)");
        m.put("upper", "*");
        m.put("year", "1=extract(year from $P1)");

        //================MySQLDialect family===============
        m = Dialect.MySQLDialect.functions;
        m.put("abs", "*");
        m.put("acos", "*");
        m.put("ascii", "*");
        m.put("asin", "*");
        m.put("isnull", "ifnull($Params)");
        m.put("nvl", "ifnull($Params)");
        m.put("atan", "*");
        m.put("avg", "1=avg($P1)");
        m.put("bin", "*");
        m.put("bit_count", "*");
        m.put("bit_length", "*");
        m.put("cast", "$CAST");
        m.put("ceil", "*");
        m.put("ceiling", "*");
        m.put("character_length", "*");
        m.put("char_length", "*");
        m.put("coalesce", "*");
        m.put("concat", "*");
        m.put("cos", "*");
        m.put("cot", "*");
        m.put("count", "*");
        m.put("crc32", "*");
        m.put("curdate", "0=curdate()");
        m.put("current_date", "0=current_date");
        m.put("current_time", "0=current_time");
        m.put("current_timestamp", "0=current_timestamp");
        m.put("curtime", "0=curtime()");
        m.put("date", "*");
        m.put("datediff", "$DATEDIFF");
        m.put("date_format", "*");
        m.put("day", "*");
        m.put("dayname", "*");
        m.put("dayofmonth", "*");
        m.put("dayofweek", "*");
        m.put("dayofyear", "*");
        m.put("degrees", "*");
        m.put("encrypt", "*");
        m.put("exp", "*");
        m.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        m.put("floor", "*");
        m.put("from_days", "*");
        m.put("from_unixtime", "*");
        m.put("hex", "*");
        m.put("hour", "*");
        m.put("last_day", "*");
        m.put("lcase", "*");
        m.put("length", "*");
        m.put("ln", "*");
        m.put("localtime", "0=localtime()");
        m.put("localtimestamp", "0=localtimestamp()");
        m.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        m.put("log", "*");
        m.put("log10", "*");
        m.put("log2", "*");
        m.put("lower", "*");
        m.put("ltrim", "*");
        m.put("max", "*");
        m.put("md5", "*");
        m.put("microseconds", "*");
        m.put("min", "*");
        m.put("minute", "*");
        m.put("mod", "*");
        m.put("month", "*");
        m.put("monthname", "*");
        m.put("now", "0=now()");
        m.put("nullif", "*");
        m.put("oct", "*");
        m.put("octet_length", "*");
        m.put("ord", "*");
        m.put("pi", "0=pi()");
        m.put("quarter", "*");
        m.put("quote", "*");
        m.put("radians", "*");
        m.put("rand", "0=rand()");
        m.put("reverse", "*");
        m.put("round", "*");
        m.put("rtrim", "*");
        m.put("second", "*");
        m.put("sec_to_time", "*");
        m.put("sha", "*");
        m.put("sha1", "*");
        m.put("sign", "*");
        m.put("sin", "*");
        m.put("soundex", "*");
        m.put("space", "*");
        m.put("sqrt", "*");
        m.put("stddev", "std($Params)");
        m.put("str", "1=cast($P1 as char)");
        m.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        m.put("sum", "*");
        m.put("sysdate", "0=sysdate()");
        m.put("tan", "*");
        m.put("time", "*");
        m.put("timediff", "*");
        m.put("timestamp", "*");
        m.put("time_to_sec", "*");
        m.put("to_days", "*");
        m.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        m.put("ucase", "*");
        m.put("unhex", "*");
        m.put("unix_timestamp", "*");
        m.put("upper", "*");
        m.put("utc_date", "0=utc_date()");
        m.put("utc_time", "0=utc_time()");
        m.put("utc_timestamp", "0=utc_timestamp()");
        m.put("week", "*");
        m.put("weekday", "*");
        m.put("weekofyear", "*");
        m.put("year", "*");
        m.put("yearweek", "*");
        m.put("to_date", "2=$P1");
        m.put("getdate", "0=now()");
        m.put("--", "0=-- ");
        m.put("with", "$DelFunc");
        m.put("convert", "$CONVERT");
        m.put("charindex", "2=instr($P2,$P1)");

        m = Dialect.MySQL5Dialect.functions;
        m.putAll(Dialect.MySQLDialect.functions);//extends from MySQLDialect

        m = Dialect.MySQL55Dialect.functions;
        m.putAll(Dialect.MySQLDialect.functions);//extends from MySQLDialect

        m = Dialect.MySQL57Dialect.functions;
        m.putAll(Dialect.MySQLDialect.functions);//extends from MySQLDialect
        m.put("current_timestamp", "0=now(6)");
        m.put("localtime", "0=now(6)");
        m.put("localtimestamp", "0=now(6)");
        m.put("now", "0=now(6)");
        m.put("sysdate", "0=sysdate(6)");

        m = Dialect.MySQL57InnoDBDialect.functions;
        m.putAll(Dialect.MySQLDialect.functions);//extends from MySQLDialect
        m.put("current_timestamp", "0=now(6)");
        m.put("localtime", "0=now(6)");
        m.put("localtimestamp", "0=now(6)");
        m.put("now", "0=now(6)");
        m.put("sysdate", "0=sysdate(6)");

        m = Dialect.MySQL5InnoDBDialect.functions;
        m.putAll(Dialect.MySQLDialect.functions);//extends from MySQLDialect

        m = Dialect.MySQLInnoDBDialect.functions;
        m.putAll(Dialect.MySQLDialect.functions);//extends from MySQLDialect

        m = Dialect.MySQLMyISAMDialect.functions;
        m.putAll(Dialect.MySQLDialect.functions);//extends from MySQLDialect

        m = Dialect.MySQL8Dialect.functions;
        m.putAll(Dialect.MySQLDialect.functions);//extends from MySQLDialect
        m.put("current_timestamp", "0=now(6)");
        m.put("localtime", "0=now(6)");
        m.put("localtimestamp", "0=now(6)");
        m.put("now", "0=now(6)");
        m.put("sysdate", "0=sysdate(6)");

        //================OracleDialect family===============
        m = Dialect.OracleDialect.functions;
        m.put("abs", "*");
        m.put("acos", "*");
        m.put("ascii", "*");
        m.put("asin", "*");
        m.put("atan", "*");
        m.put("atan2", "*");
        m.put("avg", "1=avg($P1)");
        m.put("bit_length", "1=vsize($P1)*8");
        m.put("cast", "$CAST");
        m.put("ceil", "*");
        m.put("chr", "*");
        m.put("coalesce", "$NVL_Params");
        m.put("concat", "$Lined_Params");
        m.put("cos", "*");
        m.put("count", "*");
        m.put("current_date", "0=current_date");
        m.put("current_time", "0=current_timestamp");
        m.put("current_timestamp", "0=current_timestamp");
        m.put("day", "1=extract(day from $P1)");
        m.put("exp", "*");
        m.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        m.put("floor", "*");
        m.put("hour", "1=extract(hour from $P1)");
        m.put("initcap", "*");
        m.put("instr", "*");
        m.put("last_day", "*");
        m.put("length", "*");
        m.put("ln", "*");
        m.put("locate", "2=instr($P2,$P1)");
        m.put("log", "*");
        m.put("lower", "*");
        m.put("lpad", "*");
        m.put("ltrim", "*");
        m.put("max", "*");
        m.put("min", "*");
        m.put("minute", "1=extract(minute from $P1)");
        m.put("mod", "*");
        m.put("month", "1=extract(month from $P1)");
        m.put("nullif", "*");
        m.put("nvl", "*");
        m.put("power", "*");
        m.put("replace", "*");
        m.put("round", "*");
        m.put("rpad", "*");
        m.put("rtrim", "*");
        m.put("second", "1=extract(second from $P1)");
        m.put("sign", "*");
        m.put("sin", "*");
        m.put("soundex", "*");
        m.put("sqrt", "*");
        m.put("stddev", "*");
        m.put("str", "to_char($Params)");
        m.put("substr", "*");
        m.put("substring", "substr($Params)");
        m.put("sum", "*");
        m.put("sysdate", "0=sysdate");
        m.put("tan", "*");
        m.put("to_char", "*");
        m.put("to_date", "2=$P1");
        m.put("to_timestamp", "2=$P1");
        m.put("translate", "*");
        m.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        m.put("trunc", "*");
        m.put("upper", "*");
        m.put("user", "0=user");
        m.put("variance", "*");
        m.put("year", "1=extract(year from $P1)");
        m.put("isnull", "nvl($Params)");
        m.put("ifnull", "nvl($Params)");
        m.put("now", "0=sysdate");
        m.put("getdate", "0=sysdate");
        m.put("##", "0=-- ");
        m.put("with", "$DelFunc");
        m.put("convert", "$CONVERT");
        m.put("charindex", "instr($Params)");

        m = Dialect.Oracle10gDialect.functions;
        m.putAll(Dialect.OracleDialect.functions);//extends from OracleDialect

        m = Dialect.Oracle12cDialect.functions;
        m.putAll(Dialect.OracleDialect.functions);//extends from OracleDialect

        m = Dialect.Oracle8iDialect.functions;
        m.putAll(Dialect.OracleDialect.functions);//extends from OracleDialect

        m = Dialect.Oracle9Dialect.functions;
        m.putAll(Dialect.OracleDialect.functions);//extends from OracleDialect

        m = Dialect.Oracle9iDialect.functions;
        m.putAll(Dialect.OracleDialect.functions);//extends from OracleDialect

        //================PostgreSQLDialect family===============
        m = Dialect.PostgreSQLDialect.functions;
        m.put("abs", "*");
        m.put("acos", "*");
        m.put("ascii", "*");
        m.put("asin", "*");
        m.put("atan", "*");
        m.put("avg", "1=avg($P1)");
        m.put("bit_length", "*");
        m.put("cast", "1=cast($P1)|2=cast($P1 as $P2)");
        m.put("ceil", "*");
        m.put("char_length", "*");
        m.put("chr", "*");
        m.put("coalesce", "*");
        m.put("concat", "($Lined_Params)");
        m.put("cos", "*");
        m.put("cot", "*");
        m.put("count", "*");
        m.put("current_date", "0=current_date");
        m.put("current_time", "0=current_time");
        m.put("current_timestamp", "0=current_timestamp");
        m.put("current_user", "0=current_user");
        m.put("datediff", "2=($P2::date - $P1::date)");
        m.put("date_sub", "3=($P1 - INTERVAL '$P2 $P3')");
        m.put("day", "1=extract(day from $P1)");
        m.put("degrees", "*");
        m.put("exp", "*");
        m.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        m.put("floor", "*");
        m.put("hour", "1=extract(hour from $P1)");
        m.put("initcap", "*");
        m.put("length", "*");
        m.put("ln", "*");
        m.put("localtime", "0=localtime");
        m.put("localtimestamp", "0=localtimestamp");
        m.put("locate", "2=position($P1 in $P2)|3=(position($P1 in substring($P2, $P3))+$P3-1)");
        m.put("log", "*");
        m.put("lower", "*");
        m.put("max", "*");
        m.put("md5", "*");
        m.put("min", "*");
        m.put("minute", "1=extract(minute from $P1)");
        m.put("mod", "*");
        m.put("month", "1=extract(month from $P1)");
        m.put("now", "0=now()");
        m.put("nullif", "*");
        m.put("octet_length", "*");
        m.put("radians", "*");
        m.put("rand", "0=random()");
        m.put("random", "0=random()");
        m.put("round", "*");
        m.put("second", "1=extract(second from $P1)");
        m.put("session_user", "0=session_user");
        m.put("sign", "*");
        m.put("sin", "*");
        m.put("sqrt", "*");
        m.put("stddev", "*");
        m.put("str", "1=cast($P1 as varchar)");
        m.put("substr", "*");
        m.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        m.put("sum", "*");
        m.put("tan", "*");
        m.put("to_char", "*");
        m.put("to_date", "2=$P1");
        m.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        m.put("trunc", "*");
        m.put("upper", "*");
        m.put("user", "0=user");
        m.put("variance", "*");
        m.put("year", "1=extract(year from $P1)");

        // 添加注释处理
        m.put("--", "0=--");            // 单行注释
        m.put("/*", "0=/*");            // 多行注释开始
        m.put("*/", "0=*/");            // 多行注释结束
        m.put("##", "0=--");            // 兼容MySQL单行注释

        // 添加条件表达式函数
        m.put("if", "3=CASE WHEN $P1 THEN $P2 ELSE $P3 END");
        m.put("iif", "3=CASE WHEN $P1 THEN $P2 ELSE $P3 END"); // SQL Server的IIF函数

        // 添加更多聚合函数
        m.put("listagg", "2=string_agg($P1, $P2)");  // Oracle的LISTAGG
        m.put("group_concat", "1=string_agg($P1, ',')"); // MySQL的GROUP_CONCAT

        // 添加字符串函数
        m.put("concat_ws", "2=string_agg($P2, $P1)");
        m.put("format", "2=to_char($P1, $P2)");
        m.put("repeat", "2=repeat($P1, $P2)");
        m.put("reverse", "1=reverse($P1)");
        m.put("left", "2=left($P1, $P2)");
        m.put("right", "2=right($P1, $P2)");
        m.put("space", "1=repeat(' ', $P1)");

        // 添加日期/时间函数
        m.put("date_part", "2=EXTRACT($P1 FROM $P2)");
        m.put("date_trunc", "2=date_trunc($P1, $P2)");

        // 添加注释处理
        m.put("--", "0=--");            // 单行注释
        m.put("/*", "0=/*");            // 多行注释开始
        m.put("*/", "0=*/");            // 多行注释结束
        m.put("##", "0=--");            // 兼容MySQL单行注释

        // 添加条件表达式函数
        m.put("if", "3=CASE WHEN $P1 THEN $P2 ELSE $P3 END");
        m.put("iif", "3=CASE WHEN $P1 THEN $P2 ELSE $P3 END"); // SQL Server的IIF函数

        // 添加更多聚合函数
        m.put("listagg", "2=string_agg($P1, $P2)");  // Oracle的LISTAGG
        m.put("group_concat", "1=string_agg($P1, ',')"); // MySQL的GROUP_CONCAT

        // 添加字符串函数
        m.put("concat_ws", "2=string_agg($P2, $P1)");
        m.put("format", "2=to_char($P1, $P2)");
        m.put("repeat", "2=repeat($P1, $P2)");
        m.put("reverse", "1=reverse($P1)");
        m.put("left", "2=left($P1, $P2)");
        m.put("right", "2=right($P1, $P2)");
        m.put("space", "1=repeat(' ', $P1)");

        // 添加日期/时间函数
        m.put("date_part", "2=date_part($P1, $P2)");
        m.put("date_trunc", "2=date_trunc($P1, $P2)");

        //================SQLServerDialect family===============
        m = Dialect.SQLServerDialect.functions;
        m.put("abs", "*");
        m.put("acos", "*");
        m.put("ascii", "*");
        m.put("asin", "*");
        m.put("atan", "*");
        m.put("avg", "1=avg($P1)");
        m.put("bit_length", "1=datalength($P1) * 8");
        m.put("cast", "1=cast($P1)|2=cast($P1 as $P2)");
        m.put("ceiling", "*");
        m.put("char", "*");
        m.put("coalesce", "*");
        m.put("concat", "($Add_Params)");
        m.put("cos", "*");
        m.put("cot", "*");
        m.put("count", "*");
        m.put("current_date", "0=getdate()");
        m.put("current_time", "0=getdate()");
        m.put("current_timestamp", "0=getdate()");
        m.put("day", "*");
        m.put("degrees", "*");
        m.put("exp", "*");
        m.put("extract", "1=datepart($P1)|3=datepart($P1, $P3)");
        m.put("floor", "*");
        m.put("hour", "1=datepart(hour, $P1)");
        m.put("isnull", "*");
        m.put("len", "*");
        m.put("length", "len($Params)");
        m.put("locate", "charindex($Params)");
        m.put("log", "*");
        m.put("log10", "*");
        m.put("lower", "*");
        m.put("ltrim", "*");
        m.put("max", "*");
        m.put("min", "*");
        m.put("minute", "1=datepart(minute, $P1)");
        m.put("mod", "1=$P1|2=$P1 % $P2");
        m.put("month", "*");
        m.put("nullif", "*");
        m.put("pi", "0=pi()");
        m.put("radians", "*");
        m.put("rand", "*");
        m.put("reverse", "*");
        m.put("round", "*");
        m.put("rtrim", "*");
        m.put("second", "1=datepart(second, $P1)");
        m.put("sign", "*");
        m.put("sin", "*");
        m.put("space", "*");
        m.put("sqrt", "*");
        m.put("str", "*");
        m.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        m.put("sum", "*");
        m.put("tan", "*");
        m.put("trim", "1=ltrim(rtrim($P1))|2=replace(replace(ltrim(rtrim(replace(replace($P2,' ','${space}$'),$P1,' '))),' ',$P1),'${space}$',' ')");
        m.put("upper", "*");
        m.put("user", "0=user()");
        m.put("year", "*");
        m.put("nvl", "isnull($Params)");
        m.put("to_date", "2=$P1");
        m.put("now", "0=getdate()");
        m.put("sysdate", "0=getdate()");
        m.put("--", "0=--");

        m = Dialect.SQLServer2005Dialect.functions;
        m.putAll(Dialect.SQLServerDialect.functions);//extends from SQLServerDialect

        m = Dialect.SQLServer2008Dialect.functions;
        m.putAll(Dialect.SQLServerDialect.functions);//extends from SQLServerDialect
        m.put("current_timestamp", "0=current_timestamp");

        m = Dialect.SQLServer2012Dialect.functions;
        m.putAll(Dialect.SQLServerDialect.functions);//extends from SQLServerDialect

        m = Dialect.SQLServer2016Dialect.functions;
        m.putAll(Dialect.SQLServerDialect.functions);//extends from SQLServerDialect
        m.put("current_timestamp", "0=current_timestamp");

    }

}
