package com.af.v4.system.common.datasource.enums;

import com.af.v4.system.common.datasource.utils.FnvHash;
import com.clickhouse.jdbc.ClickHouseDriver;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import dm.jdbc.driver.DmDriver;
import oracle.jdbc.OracleDriver;

/**
 * 数据库类型
 */
public enum DbType {
    postgresql(1 << 4, org.postgresql.Driver.class.getCanonicalName()),
    sqlserver(1 << 5, SQLServerDriver.class.getCanonicalName()),
    oracle(1 << 6, OracleDriver.class.getCanonicalName()),
    mysql(1 << 7, com.mysql.cj.jdbc.Driver.class.getCanonicalName()),
    dm(1 << 12, DmDriver.class.getCanonicalName()), // dm.jdbc.driver.DmDriver
    clickhouse(1 << 28, ClickHouseDriver.class.getCanonicalName()),
    doris(1L << 44, com.mysql.cj.jdbc.Driver.class.getCanonicalName()),
    opengauss(1L << 45, org.postgresql.Driver.class.getCanonicalName());

    public final long mask;
    public final String driverClassName;
    public final long hashCode64;

    DbType(long mask, String driverClassName) {
        this.mask = mask;
        this.driverClassName = driverClassName;
        this.hashCode64 = FnvHash.hashCode64(name());
    }

    public static long of(DbType... types) {
        long value = 0;

        for (DbType type : types) {
            value |= type.mask;
        }

        return value;
    }

    public static DbType of(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        try {
            return valueOf(name);
        } catch (Exception e) {
            return null;
        }
    }

    public static DbType ofByDriverClassName(String driverClassName) {
        if (driverClassName == null || driverClassName.isEmpty()) {
            return null;
        }
        for (DbType type : DbType.values()) {
            if (type.driverClassName.equals(driverClassName)) {
                return type;
            }
        }
        return null;
    }

    public final boolean equals(String other) {
        return this == of(other);
    }
}
