/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.config;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.enums.DbType;
import java.util.List;

public class AfDataSourceConfig {
    private String name;
    private String driverClassName;
    private DbType type;
    private String url;
    private String username;
    private String password;
    private String dialect;
    private List<String> cfgLocations;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        DbType dbType = DbType.ofByDriverClassName(driverClassName);
        if (dbType == null) {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u9a71\u52a8\uff1a" + driverClassName);
        }
        this.driverClassName = driverClassName;
        this.type = dbType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public List<String> getCfgLocations() {
        return this.cfgLocations;
    }

    public void setCfgLocations(List<String> cfgLocations) {
        this.cfgLocations = cfgLocations;
    }

    public DbType getType() {
        return this.type;
    }

    public void setType(String type) {
        DbType dbType = DbType.of(type.toLowerCase());
        if (dbType == null) {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + type);
        }
        this.driverClassName = dbType.driverClassName;
        this.type = dbType;
    }
}

