/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.wrapper;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.af.v4.system.common.datasource.enums.DbType;
import com.zaxxer.hikari.HikariDataSource;

public class AfDataSourceWrapper {
    private final HikariDataSource ds;
    private final AfDataSourceConfig config;
    private final DbType dbType;

    public AfDataSourceWrapper(HikariDataSource ds, AfDataSourceConfig config) {
        this.ds = ds;
        this.config = config;
        String driverClassName = config.getDriverClassName();
        if (driverClassName.contains("SQLServerDriver")) {
            this.dbType = DbType.sqlserver;
        } else if (driverClassName.contains("OracleDriver")) {
            this.dbType = DbType.oracle;
        } else if (driverClassName.contains("mysql")) {
            this.dbType = DbType.mysql;
        } else if (driverClassName.contains("ClickHouseDriver")) {
            this.dbType = DbType.clickhouse;
        } else if (driverClassName.contains("postgresql")) {
            this.dbType = DbType.postgresql;
        } else {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u9a71\u52a8\uff1a" + driverClassName);
        }
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public HikariDataSource getDataSource() {
        return this.ds;
    }

    public AfDataSourceConfig getConfig() {
        return this.config;
    }
}

