package com.af.v4.system.common.datasource.wrapper;

import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.af.v4.system.common.datasource.enums.DbType;
import com.zaxxer.hikari.HikariDataSource;

/**
 * 数据源扩展
 */
public class AfDataSourceWrapper {
    private final HikariDataSource ds;
    private final AfDataSourceConfig config;
    private DbType dbType;

    public AfDataSourceWrapper(HikariDataSource ds, AfDataSourceConfig config) {
        this.ds = ds;
        this.config = config;
        String driverClassName = config.getDriverClassName();
        if (driverClassName.contains("SQLServerDriver")) {
            dbType = DbType.sqlserver;
        } else if (driverClassName.contains("OracleDriver")) {
            dbType = DbType.oracle;
        } else if (driverClassName.contains("mysql")) {
            dbType = DbType.mysql;
        } else if (driverClassName.contains("ClickHouseDriver")) {
            dbType = DbType.clickhouse;
        }
    }

    public DbType getDbType() {
        return dbType;
    }

    public HikariDataSource getDataSource() {
        return ds;
    }

    public AfDataSourceConfig getConfig() {
        return config;
    }
}
