/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.provider;

import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Objects;

public class DataSourceProvider {
    private static final int DEFAULT_MAX_ACTIVE_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;

    public static HikariDataSource create(AfDataSourceConfig config, Integer minimumIdle, Integer maximumPoolSize, Integer connectionTimeout, Integer idleTimeout, Integer maxLifetime) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName(config.getName());
        hikariConfig.setDriverClassName(config.getDriverClassName());
        hikariConfig.setJdbcUrl(config.getUrl());
        hikariConfig.setUsername(config.getUsername());
        hikariConfig.setPassword(config.getPassword());
        hikariConfig.setMinimumIdle(Objects.requireNonNullElse(minimumIdle, DEFAULT_MAX_ACTIVE_SIZE).intValue());
        hikariConfig.setMaximumPoolSize(Objects.requireNonNullElse(maximumPoolSize, DEFAULT_MAX_ACTIVE_SIZE).intValue());
        hikariConfig.setConnectionTimeout((long)Objects.requireNonNullElse(connectionTimeout, 30000).intValue());
        hikariConfig.setIdleTimeout((long)Objects.requireNonNullElse(idleTimeout, 30000).intValue());
        hikariConfig.setMaxLifetime((long)Objects.requireNonNullElse(maxLifetime, 180000).intValue());
        return new HikariDataSource(hikariConfig);
    }
}

