/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.config;

import com.af.v4.system.common.core.exception.CheckedException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.af.v4.system.common.datasource.provider.DataSourceProvider;
import com.af.v4.system.common.datasource.wrapper.AfDataSourceWrapper;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Configuration
@ConfigurationProperties(prefix="db")
@Component
public class DynamicDataSourceConfig {
    private List<AfDataSourceConfig> dataSourceList;
    private List<String> subClass;
    private Integer minimumIdle;
    private Integer maximumPoolSize;
    private Integer connectionTimeout;
    private Integer idleTimeout;
    private Integer maxLifetime;

    @Bean
    @Primary
    public DynamicDataSource routingDataSource() {
        if (Optional.ofNullable(this.dataSourceList).isEmpty()) {
            throw new CheckedException("\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff1a\u6570\u636e\u6e90\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9879\u76ee\u662f\u5426\u6b63\u786e\u52a0\u8f7d\u4e86nacos\u4e2d\u5fc3\u5bf9\u5e94\u7684\u4e1a\u52a1\u914d\u7f6e");
        }
        HashMap<String, AfDataSourceWrapper> targetDataSources = new HashMap<String, AfDataSourceWrapper>(this.dataSourceList.size());
        this.dataSourceList.forEach(item -> {
            HikariDataSource dataSource = DataSourceProvider.create(item, this.minimumIdle, this.maximumPoolSize, this.connectionTimeout, this.idleTimeout, this.maxLifetime);
            targetDataSources.put(item.getName(), new AfDataSourceWrapper(dataSource, (AfDataSourceConfig)item));
        });
        return new DynamicDataSource((DataSource)((AfDataSourceWrapper)targetDataSources.get("master")).getDataSource(), targetDataSources);
    }

    public List<AfDataSourceConfig> getDataSourceList() {
        return this.dataSourceList;
    }

    public void setDataSourceList(List<AfDataSourceConfig> dataSourceList) {
        this.dataSourceList = dataSourceList;
    }

    public List<String> getSubClass() {
        return this.subClass;
    }

    public void setSubClass(List<String> subClass) {
        this.subClass = subClass;
    }

    public Integer getMinimumIdle() {
        return this.minimumIdle;
    }

    public void setMinimumIdle(Integer minimumIdle) {
        this.minimumIdle = minimumIdle;
    }

    public Integer getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Integer getMaxLifetime() {
        return this.maxLifetime;
    }

    public void setMaxLifetime(Integer maxLifetime) {
        this.maxLifetime = maxLifetime;
    }
}

