package com.af.v4.system.common.datasource;

import com.alibaba.druid.DbType;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * 动态数据源工具类
 */
public class DynamicDataSource extends AbstractRoutingDataSource {
    /**
     * 默认数据源名称
     */
    public static final String DEFAULT_DATASOURCE_NAME = "master";
    private static final ThreadLocal<String> contextHolder = new ThreadLocal<>();
    private static final Map<String, MyDruidDataSource> dataSourceInfo = new HashMap<>(3);

    public DynamicDataSource(DataSource defaultTargetDataSource, Map<Object, Object> targetDataSources) {
        for (Map.Entry<Object, Object> item : targetDataSources.entrySet()) {
            dataSourceInfo.put((String) item.getKey(), (MyDruidDataSource) item.getValue());
        }
        super.setDefaultTargetDataSource(defaultTargetDataSource);
        super.setTargetDataSources(targetDataSources);
        super.afterPropertiesSet();
    }

    public DynamicDataSource() {

    }

    /**
     * 获取当前数据源名称
     *
     * @return 数据源名称
     */
    public static String getDataSource() {
        return Optional.ofNullable(contextHolder.get()).orElse(DEFAULT_DATASOURCE_NAME);
    }

    /**
     * 设置数据源
     *
     * @param dataSource 数据源名称
     */
    public static void setDataSource(String dataSource) {
        contextHolder.set(dataSource);
    }

    public static void clearDataSource() {
        contextHolder.remove();
    }

    public static Map<String, MyDruidDataSource> getDataSourceList() {
        return dataSourceInfo;
    }

    public static MyDruidDataSource getDruidDataSource() {
        return getDataSourceList().get(DynamicDataSource.getDataSource());
    }

    public static DbType getDbType() {
        return DbType.of(DynamicDataSource.getDruidDataSource().getDbType());
    }

    @Override
    protected Object determineCurrentLookupKey() {
        return getDataSource();
    }
}
