/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.config;

import com.af.v4.system.common.core.exception.CheckedException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.MyDruidDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Configuration
@ConfigurationProperties(prefix="db")
@Component
public class DynamicDataSourceConfig {
    private final int DEFAULT_MAX_ACTIVE_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private List<MyDruidDataSource> dataSourceList;
    private List<String> subClass;
    private Integer initialSize;
    private Integer minIdle;
    private Integer maxActive;
    private Integer maxWait;
    private Integer connectTimeout;
    private Integer socketTimeout;

    @Bean
    @Primary
    public DynamicDataSource routingDataSource() {
        if (Optional.ofNullable(this.dataSourceList).isEmpty()) {
            throw new CheckedException("\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff1a\u6570\u636e\u6e90\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9879\u76ee\u662f\u5426\u6b63\u786e\u52a0\u8f7d\u4e86nacos\u4e2d\u5fc3\u5bf9\u5e94\u7684\u4e1a\u52a1\u914d\u7f6e");
        }
        HashMap<Object, Object> targetDataSources = new HashMap<Object, Object>(this.dataSourceList.size());
        this.dataSourceList.forEach(item -> {
            this.setProperties((DruidDataSource)item);
            targetDataSources.put(item.getName(), item);
        });
        return new DynamicDataSource((DataSource)((Object)this.dataSourceList.get(0)), targetDataSources);
    }

    private void setProperties(DruidDataSource item) {
        Properties connectProperties = new Properties();
        item.setInitialSize(Objects.requireNonNullElse(this.initialSize, 5).intValue());
        item.setMinIdle(Objects.requireNonNullElse(this.minIdle, 5).intValue());
        item.setMaxActive(Objects.requireNonNullElse(this.maxActive, this.DEFAULT_MAX_ACTIVE_SIZE).intValue());
        item.setMaxWait((long)Objects.requireNonNullElse(this.maxWait, 30000).intValue());
        item.setConnectTimeout(Objects.requireNonNullElse(this.connectTimeout, 10000).intValue());
        item.setSocketTimeout(Objects.requireNonNullElse(this.socketTimeout, 30000).intValue());
        item.setTimeBetweenEvictionRunsMillis(60000L);
        item.setMinEvictableIdleTimeMillis(180000L);
        item.setTestWhileIdle(true);
        item.setTestOnBorrow(false);
        item.setTestOnReturn(false);
        item.setUseUnfairLock(true);
        String driverClassName = item.getDriverClassName();
        if (driverClassName.contains("SQLServer") || driverClassName.contains("Oracle") || driverClassName.contains("clickhouse")) {
            item.setPoolPreparedStatements(true);
            item.setMaxPoolPreparedStatementPerConnectionSize(20);
            if (driverClassName.contains("Oracle")) {
                connectProperties.setProperty("oracle.net.CONNECT_TIMEOUT", String.valueOf(item.getConnectTimeout()));
                connectProperties.setProperty("oracle.jdbc.ReadTimeout", String.valueOf(item.getSocketTimeout()));
            }
        }
        if (driverClassName.contains("Oracle")) {
            item.setValidationQuery("select 1 from dual");
        } else {
            item.setValidationQuery("select 1");
        }
        try {
            item.setFilters("stat,slf4j");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        boolean isMergeSql = !driverClassName.contains("clickhouse");
        connectProperties.setProperty("druid.stat.mergeSql", String.valueOf(isMergeSql));
        connectProperties.setProperty("druid.stat.slowSqlMilli", "5000");
        item.setConnectProperties(connectProperties);
    }

    public List<MyDruidDataSource> getDataSourceList() {
        return this.dataSourceList;
    }

    public void setDataSourceList(List<MyDruidDataSource> dataSourceList) {
        this.dataSourceList = dataSourceList;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
    }

    public Integer getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(Integer maxWait) {
        this.maxWait = maxWait;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public List<String> getSubClass() {
        return this.subClass;
    }

    public void setSubClass(List<String> subClass) {
        this.subClass = subClass;
    }
}

