/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource;

import com.af.v4.system.common.datasource.MyDruidDataSource;
import com.alibaba.druid.DbType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    public static final String DEFAULT_DATASOURCE_NAME = "master";
    private static final ThreadLocal<String> contextHolder = new ThreadLocal();
    private static final Map<String, MyDruidDataSource> dataSourceInfo = new HashMap<String, MyDruidDataSource>(3);

    public DynamicDataSource(DataSource defaultTargetDataSource, Map<Object, Object> targetDataSources) {
        for (Map.Entry<Object, Object> item : targetDataSources.entrySet()) {
            dataSourceInfo.put((String)item.getKey(), (MyDruidDataSource)((Object)item.getValue()));
        }
        super.setDefaultTargetDataSource((Object)defaultTargetDataSource);
        super.setTargetDataSources(targetDataSources);
        super.afterPropertiesSet();
    }

    public DynamicDataSource() {
    }

    public static String getDataSource() {
        return Optional.ofNullable(contextHolder.get()).orElse(DEFAULT_DATASOURCE_NAME);
    }

    public static void setDataSource(String dataSource) {
        contextHolder.set(dataSource);
    }

    public static void clearDataSource() {
        contextHolder.remove();
    }

    public static Map<String, MyDruidDataSource> getDataSourceList() {
        return dataSourceInfo;
    }

    public static MyDruidDataSource getDruidDataSource() {
        return DynamicDataSource.getDataSourceList().get(DynamicDataSource.getDataSource());
    }

    public static DbType getDbType() {
        return DbType.of((String)DynamicDataSource.getDruidDataSource().getDbType());
    }

    protected Object determineCurrentLookupKey() {
        return DynamicDataSource.getDataSource();
    }
}

