/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource;

import com.af.v4.system.common.datasource.MyDruidDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final ThreadLocal<String> contextHolder = new ThreadLocal();
    private static final String DEFAULT_DATASOURCE_NAME = "master";
    private static final Map<String, MyDruidDataSource> dataSourceInfo = new HashMap<String, MyDruidDataSource>(3);

    public DynamicDataSource(DataSource defaultTargetDataSource, Map<Object, Object> targetDataSources) {
        for (Map.Entry<Object, Object> item : targetDataSources.entrySet()) {
            dataSourceInfo.put((String)item.getKey(), (MyDruidDataSource)((Object)item.getValue()));
        }
        super.setDefaultTargetDataSource((Object)defaultTargetDataSource);
        super.setTargetDataSources(targetDataSources);
        super.afterPropertiesSet();
    }

    public static String getDataSource() {
        String source = contextHolder.get();
        if (source == null) {
            return DEFAULT_DATASOURCE_NAME;
        }
        return source;
    }

    public static void setDataSource(String dataSource) {
        contextHolder.set(dataSource);
    }

    public static void clearDataSource() {
        contextHolder.remove();
    }

    public static Map<String, MyDruidDataSource> getDataSourceList() {
        return dataSourceInfo;
    }

    public static MyDruidDataSource getDruidDataSource() {
        return DynamicDataSource.getDataSourceList().get(DynamicDataSource.getDataSource());
    }

    protected Object determineCurrentLookupKey() {
        return DynamicDataSource.getDataSource();
    }
}

