package com.af.v4.system.common.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;

/**
 * 动态数据源工具类
 */
public class DynamicDataSource extends AbstractRoutingDataSource {
    private static final ThreadLocal<String> contextHolder = new ThreadLocal<>();

    private static final Map<String, DruidDataSource> dataSourceInfo = new HashMap<>(3);

    public DynamicDataSource(DataSource defaultTargetDataSource, Map<Object, Object> targetDataSources) {
        for (Map.Entry<Object, Object> item : targetDataSources.entrySet()) {
            dataSourceInfo.put((String) item.getKey(), (DruidDataSource) item.getValue());
        }
        super.setDefaultTargetDataSource(defaultTargetDataSource);
        super.setTargetDataSources(targetDataSources);
        super.afterPropertiesSet();
    }

    public static String getDataSource() {
        String source = contextHolder.get();
        if (source == null) {
            return "master";
        }
        return source;
    }

    public static void setDataSource(String dataSource) {
        contextHolder.set(dataSource);
    }

    public static void clearDataSource() {
        contextHolder.remove();
    }

    public static Map<String, DruidDataSource> getDataSourceList() {
        return dataSourceInfo;
    }

    public static DruidDataSource getDruidDataSource() {
        return getDataSourceList().get(DynamicDataSource.getDataSource());
    }

    @Override
    protected Object determineCurrentLookupKey() {
        return getDataSource();
    }
}
