package com.af.v4.system.common.compatibility.service;

import com.af.v4.system.common.core.enums.CompatibleVersion;
import com.af.v4.system.common.core.utils.ApplicationUtils;
import org.springframework.stereotype.Component;

/**
 * SQL兼容服务
 */
@Component
public class SQLCompatService {
    private final CompatibleVersion version;

    public SQLCompatService(ApplicationUtils applicationUtils) {
        this.version = applicationUtils.getVersion();
    }

    /**
     * 获取表档案主键原始字段名
     *
     * @return 表档案主键原始字段名
     */
    public String getOriginalMeterId() {
        return switch (version) {
            case V2 -> "f_user_id";
            default -> "f_userfiles_id";
        };
    }

    /**
     * 获取换表记录表名
     *
     * @return 换表记录表名
     */
    public String getChangeMeterTableName() {
        return switch (version) {
            case V2 -> "t_changemeter";
            default -> "t_changetables";
        };
    }

    /**
     * 获取物联网抄表数据表名
     */
    public String getHandPlanTableName() {
        return switch (version) {
            case V2, V3 -> "t_handplan";
            default -> "t_web_handplan";
        };
    }
}
