/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.cdc.connector.source.sqlservercdc;

import com.af.v4.system.common.cdc.connector.source.Source;
import com.af.v4.system.common.datasource.MyDruidDataSource;
import com.ververica.cdc.connectors.sqlserver.SqlServerSource;
import com.ververica.cdc.connectors.sqlserver.table.StartupOptions;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SqlServerCdcSource
extends Source {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerCdcSource.class);

    @Override
    protected DebeziumSourceFunction buildDataSource(JSONObject globalConfig, JSONObject sourceConfig, MyDruidDataSource dataSource) {
        String connectionString = dataSource.getRawJdbcUrl();
        String[] parts = connectionString.split(":");
        int firstIndex = connectionString.indexOf("database=") + "database=".length();
        int secondIndex = connectionString.indexOf(";", firstIndex + 1);
        String host = parts[2].substring(2);
        int port = Integer.parseInt(parts[3].substring(0, parts[3].indexOf(";")));
        String dbName = connectionString.substring(firstIndex, secondIndex);
        String table = sourceConfig.getString("table");
        return SqlServerSource.builder().hostname(host).port(port).database(dbName).tableList(new String[]{table}).username(dataSource.getUsername()).password(dataSource.getPassword()).startupOptions(globalConfig.getBoolean("totalQuantity") ? StartupOptions.initial() : StartupOptions.latest()).deserializer((DebeziumDeserializationSchema)this.schema).build();
    }
}

