/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.cdc.connector.source.oracle;

import com.af.v4.system.common.cdc.connector.source.Source;
import com.af.v4.system.common.datasource.MyDruidDataSource;
import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.oracle.OracleSource;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OracleCdcSource
extends Source {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleCdcSource.class);

    @Override
    protected DebeziumSourceFunction buildDataSource(JSONObject globalConfig, JSONObject sourceConfig, MyDruidDataSource dataSource) {
        String connectionString = dataSource.getRawJdbcUrl();
        String[] parts = connectionString.split(":");
        String host = parts[3].substring(3);
        int port = Integer.parseInt(parts[4]);
        String dbName = connectionString.substring(connectionString.lastIndexOf("/") + 1);
        String table = sourceConfig.getString("table");
        return OracleSource.builder().hostname(host).port(Integer.valueOf(port)).database(dbName).tableList(new String[]{table}).username(dataSource.getUsername()).password(dataSource.getPassword()).startupOptions(globalConfig.getBoolean("totalQuantity") ? StartupOptions.initial() : StartupOptions.latest()).deserializer((DebeziumDeserializationSchema)this.schema).build();
    }
}

