package com.af.v4.system.common.cdc.connector.source.oracle;

import com.af.v4.system.common.cdc.connector.source.Source;
import com.af.v4.system.common.datasource.MyDruidDataSource;
import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.oracle.OracleSource;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * Oracle CdcSource
 */
@Component
public class OracleCdcSource extends Source {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleCdcSource.class);

    /**
     * 构建数据源
     *
     * @return
     */
    @Override
    protected DebeziumSourceFunction buildDataSource(JSONObject globalConfig, JSONObject sourceConfig, MyDruidDataSource dataSource) {
        // 获取数据库连接字符串
        String connectionString = dataSource.getRawJdbcUrl();
        String[] parts = connectionString.split(":");
        // 初始化信息
        String host = parts[3].substring(3);
        int port = Integer.parseInt(parts[4]);
        String dbName = connectionString.substring(connectionString.lastIndexOf("/") + 1);
        // 获取表名
        String table = sourceConfig.getString("table");

        return OracleSource.builder()
                .hostname(host)
                .port(port)
                .database(dbName)
                .tableList(table)
                .username(dataSource.getUsername())
                .password(dataSource.getPassword())
                /*
                 * initial:初始化快照,即全量导入后增量导入(检测更新数据写入)
                 * latest:只进行增量导入(不读取历史变化)
                 * 这里通过判断传递过来的参数进行选择
                 */
                .startupOptions(globalConfig.getBoolean("totalQuantity") ? StartupOptions.initial() : StartupOptions.latest())
                .deserializer(schema)
                .build();
    }
}
