package com.af.v4.system.common.cdc.enums;

/**
 * 配置类枚举
 */
public class ConfigureEnum {
    public enum NumEnum {
        PARALLELISM(1),
        RESTART_COUNT(3);

        private final Integer num;

        NumEnum(Integer num) {
            this.num = num;
        }

        public Integer getNum() {
            return num;
        }
    }

    public enum TimeEnum {
        /**
         * 检查点执行间隔
         */
        CHECKPOINT_INTERVAL(5 * 1000L),

        /**
         * 检查点超时时间
         */
        CHECKPOINT_TIMEOUT(60 * 1000L),

        /**
         * 重启策略时间间隔
         */
        ATTEMPT_TO_RESTART_DELAY(3 * 1000L);
        private final Long time;

        TimeEnum(Long time) {
            this.time = time;
        }

        public Long getTime() {
            return time;
        }
    }
}
