package com.af.v4.system.common.cdc.connector.source.sqlservercdc;

import com.af.v4.system.common.cdc.connector.source.Source;
import com.af.v4.system.common.datasource.MyDruidDataSource;
import com.ververica.cdc.connectors.sqlserver.SqlServerSource;
import com.ververica.cdc.connectors.sqlserver.table.StartupOptions;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * SQLServerCdc source
 */
@Component
public class SqlServerCdcSource extends Source {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerCdcSource.class);

    /**
     * 构建数据源
     *
     * @return
     */
    @Override
    protected DebeziumSourceFunction buildDataSource(JSONObject globalConfig, JSONObject sourceConfig, MyDruidDataSource dataSource) {
        // 获取数据库连接字符串
        String connectionString = dataSource.getRawJdbcUrl();
        String[] parts = connectionString.split(":");
        int firstIndex = connectionString.indexOf("database=") + "database=".length();
        int secondIndex = connectionString.indexOf(";", firstIndex + 1);
        // 初始化信息
        String host = parts[2].substring(2);
        int port = Integer.parseInt(parts[3].substring(0, parts[3].indexOf(";")));
        String dbName = connectionString.substring(firstIndex, secondIndex);
        // 获取表名
        String table = sourceConfig.getString("table");

        return SqlServerSource.builder()
                .hostname(host)
                .port(port)
                .database(dbName)
                .tableList(table)
                .username(dataSource.getUsername())
                .password(dataSource.getPassword())
                /*
                 * initial:初始化快照,即全量导入后增量导入(检测更新数据写入)
                 * latest:只进行增量导入(不读取历史变化)
                 * 这里通过判断传递过来的参数进行选择
                 */
                .startupOptions(globalConfig.getBoolean("totalQuantity") ? StartupOptions.initial() : StartupOptions.latest())
                .deserializer(schema)
                .build();
    }
}
