/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.cdc.utils;

import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import io.debezium.data.Envelope;
import java.util.HashMap;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Collector;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class JsonDebeziumDeserializationSchema
implements DebeziumDeserializationSchema {
    public void deserialize(SourceRecord sourceRecord, Collector collector) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String topic = sourceRecord.topic();
        String[] split = topic.split("[.]");
        String database = split[1];
        String table = split[2];
        hashMap.put("database", database);
        hashMap.put("table", table);
        Envelope.Operation operation = Envelope.operationFor((SourceRecord)sourceRecord);
        Struct struct = (Struct)sourceRecord.value();
        Struct after = struct.getStruct("after");
        Struct before = struct.getStruct("before");
        if (before != null && after != null) {
            schema = after.schema();
            hm = new HashMap<String, Object>();
            for (Field field : schema.fields()) {
                hm.put(field.name(), after.get(field.name()));
            }
            hashMap.put("data", hm);
        } else if (after != null) {
            schema = after.schema();
            hm = new HashMap();
            for (Field field : schema.fields()) {
                hm.put(field.name(), after.get(field.name()));
            }
            hashMap.put("data", hm);
        } else if (before != null) {
            schema = before.schema();
            hm = new HashMap();
            for (Field field : schema.fields()) {
                hm.put(field.name(), before.get(field.name()));
            }
            hashMap.put("data", hm);
        }
        String operationStr = operation.toString().toLowerCase();
        String type = null;
        switch (operationStr) {
            case "create": {
                type = "insert";
                break;
            }
            case "delete": {
                type = "delete";
                break;
            }
            case "update": {
                type = "update";
            }
        }
        hashMap.put("type", type);
        collector.collect((Object)new JSONObject(hashMap).toString());
    }

    public TypeInformation<String> getProducedType() {
        return BasicTypeInfo.STRING_TYPE_INFO;
    }
}

