/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.cdc.connector.sink;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.mq.RocketMQProducer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.rocketmq.client.producer.SendStatus;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Sink
extends RichSinkFunction<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sink.class);
    private static final Logger CDC_ERROR_LOGGER = LoggerFactory.getLogger((String)"cdcErrorLog");
    protected String globalConfigStr;
    protected RocketMQProducer rocketMQProducer;

    public Sink(String globalConfigStr) {
        this.globalConfigStr = globalConfigStr;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.rocketMQProducer = (RocketMQProducer)SpringUtils.getBean(RocketMQProducer.class);
    }

    public void invoke(String value, SinkFunction.Context context) {
        JSONObject valueObj = new JSONObject(value);
        JSONObject globalConfig = new JSONObject(this.globalConfigStr);
        JSONObject sink = globalConfig.getJSONObject("sink");
        String table = sink.getString("table");
        JSONObject paramsData = new JSONObject();
        if (valueObj.has("type")) {
            paramsData.put("type", (Object)valueObj.get("type").toString());
        }
        JSONObject data = valueObj.getJSONObject("data");
        try {
            paramsData.put("dataSourceName", (Object)sink.getString("name"));
            paramsData.put("entityData", (Object)data);
            paramsData.put("table", (Object)table);
            this.exec(globalConfig, paramsData);
            JSONObject result = this.rocketMQProducer.syncSend("AF_LOGIC_TOPIC", globalConfig.getString("dataSyncLogic"), paramsData.toString());
            if (!result.getString("sendStatus").equals(SendStatus.SEND_OK.name())) {
                throw new ServiceException("\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u4fe1\u606f\uff1a" + result);
            }
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                ServiceException ex = (ServiceException)e;
                LOGGER.error("\u6570\u636e\u5904\u7406\u5931\u8d25.\n {}", (Object)ex.getDetailMessage());
            } else {
                LOGGER.error("\u6570\u636e\u5904\u7406\u5931\u8d25.", (Throwable)e);
            }
            CDC_ERROR_LOGGER.info(paramsData + ",");
        }
    }

    public abstract void exec(JSONObject var1, JSONObject var2) throws Exception;
}

