package com.af.v4.system.common.ai.controller;

import com.af.v4.system.common.ai.service.AiService;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.plugins.core.CommonTools;
import org.json.JSONObject;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping("/ai")
public class ChatController {

    private final AiService aiService;

    public ChatController(AiService aiService) {
        this.aiService = aiService;
    }

    /**
     * 流式对话
     *
     * @param params 请求参数
     *               chatId：对话标识
     *               userMessage：发起内容
     *               model：ai模型
     *               prompt：prompt提示
     * @return 回复
     */
    @RequestMapping(value = "/chat", produces = MediaType.TEXT_EVENT_STREAM_VALUE)
    public Flux<String> chat(@RequestBody String params) {
        JSONObject obj = new JSONObject(params);
        ChatClient client = aiService.buildChatClient(obj.getString("model"), obj.optString("prompt", null));
        return aiService.chat(client, obj.getString("chatId"), obj.getString("userMessage"));
    }

    /**
     * 同步对话
     *
     * @param params 请求参数
     *               chatId：对话标识
     *               userMessage：发起内容
     *               model：ai模型
     *               prompt：prompt提示
     * @return 回复
     */
    @RequestMapping(value = "/syncChat", produces = MediaType.APPLICATION_JSON_VALUE)
    public R<String> syncChat(@RequestBody String params) {
        JSONObject obj = new JSONObject(params);
        ChatClient client = aiService.buildChatClient(obj.getString("model"), obj.optString("prompt", null));
        String result = aiService.syncChat(client, obj.getString("chatId"), obj.getString("userMessage"));
        return R.ok(result);
    }

    /**
     * 发起一轮简单对话
     *
     * @param input 发起内容
     * @param model ai模型
     * @return 回复
     */
    @GetMapping(value = "/simpleChat")
    public R<String> simpleChat(@RequestParam("input") String input, @RequestParam("model") String model) {
        ChatClient client = aiService.buildChatClient(model);
        String result = aiService.syncChat(client, CommonTools.getUUID(), input);
        return R.ok(result);
    }

}
