/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.ai.controller;

import com.af.v4.system.common.ai.service.AiService;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.plugins.core.CommonTools;
import org.json.JSONObject;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"/ai"})
public class ChatController {
    private final AiService aiService;

    public ChatController(AiService aiService) {
        this.aiService = aiService;
    }

    @RequestMapping(value={"/chat"}, produces={"text/event-stream"})
    public Flux<String> chat(@RequestBody String params) {
        JSONObject obj = new JSONObject(params);
        ChatClient client = this.aiService.buildChatClient(obj.getString("model"), obj.optString("prompt", null));
        return this.aiService.chat(client, obj.getString("chatId"), obj.getString("userMessage"));
    }

    @RequestMapping(value={"/syncChat"}, produces={"application/json"})
    public R<String> syncChat(@RequestBody String params) {
        JSONObject obj = new JSONObject(params);
        ChatClient client = this.aiService.buildChatClient(obj.getString("model"), obj.optString("prompt", null));
        String result = this.aiService.syncChat(client, obj.getString("chatId"), obj.getString("userMessage"));
        return R.ok((Object)result);
    }

    @GetMapping(value={"/simpleChat"})
    public R<String> simpleChat(@RequestParam(value="input") String input, @RequestParam(value="model") String model) {
        ChatClient client = this.aiService.buildChatClient(model);
        String result = this.aiService.syncChat(client, CommonTools.getUUID(), input);
        return R.ok((Object)result);
    }
}

