package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteAppService;
import com.af.v4.system.common.core.domain.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 应用服务降级处理
 */
@Component
public class RemoteAppFallbackFactory implements FallbackFactory<RemoteAppService> {
    private static final Logger log = LoggerFactory.getLogger(RemoteAppFallbackFactory.class);

    @Override
    public RemoteAppService create(Throwable throwable) {
        log.warn("应用服务调用失败，{}", throwable.getMessage());
        return new RemoteAppService() {
            @Override
            public R<Map<String, Object>> getAppInfo(String source) {
                return R.fail("获取应用信息失败:" + throwable.getMessage());
            }

            @Override
            public R<Integer> compareAppVersion(String version, String source) {
                return R.fail("比较应用版本号失败:" + throwable.getMessage());
            }

            @Override
            public R<Integer> compareLiuLiVersion(String version, String source) {
                return R.fail("比较琉璃框架版本号失败:" + throwable.getMessage());
            }
        };
    }
}
