package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteLiuLiService;
import com.af.v4.system.common.core.domain.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 琉璃中心降级处理
 */
@Component
public class RemoteLiuLiFallbackFactory implements FallbackFactory<RemoteLiuLiService> {
    private static final Logger log = LoggerFactory.getLogger(RemoteLiuLiFallbackFactory.class);

    @Override
    public RemoteLiuLiService create(Throwable throwable) {
        log.warn("琉璃中心调用失败，{}", throwable.getMessage());
        return new RemoteLiuLiService() {
            @Override
            public R<Map<String, Object>> getConfigByClient(String params, String source) {
                return R.fail("获取客户端配置失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> batchGetConfigByClient(String params, String source) {
                return R.fail("批量获取客户端配置失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> parseConfigByClient(String params, String source) {
                return R.fail("解析客户端配置失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> uploadErrorLog(String params, String source) {
                return R.fail("上报应用错误日志失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> uploadHeartBeat(String params, String source) {
                return R.fail("上报应用心跳失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> saveApplicationInfo(String params, String source) {
                return R.fail("保存生产环境应用信息失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> checkV4Version(String params, String source) {
                return R.fail("检查琉璃架构版本失败:" + throwable.getMessage());
            }
        };
    }
}
