package com.af.v4.system.api;

import com.af.v4.system.api.factory.RemoteLogicFallbackFactory;
import com.af.v4.system.common.core.constant.SecurityConstants;
import com.af.v4.system.common.core.constant.ServiceNameConstants;
import com.af.v4.system.common.core.domain.R;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.Map;

/**
 * 应用服务
 *
 * @author Mr.river
 */
@FeignClient(contextId = "remoteAppService",
        value = ServiceNameConstants.GATEWAY_SERVICE,
        fallbackFactory = RemoteLogicFallbackFactory.class)
public interface RemoteAppService {
    /**
     * 获取远程应用信息
     *
     * @return 结果
     */
    @GetMapping("/app")
    R<Map<String, Object>> getAppInfo(@RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 获取远程应用信息
     *
     * @return 结果
     */
    @GetMapping("/app/compare/{version}")
    R<Integer> compareAppVersion(@PathVariable("version") String version, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 获取远程应用信息
     *
     * @return 结果
     */
    @GetMapping("/app/compareLiuLi/{version}")
    R<Integer> compareLiuLiVersion(@PathVariable("version") String version, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

}
