package com.af.v4.system.api;

import com.af.v4.system.api.factory.RemoteLogicFallbackFactory;
import com.af.v4.system.common.core.constant.SecurityConstants;
import com.af.v4.system.common.core.constant.ServiceNameConstants;
import com.af.v4.system.common.core.domain.R;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.Map;

/**
 * 远程调用琉璃中心
 *
 * @author Mr.river
 */
@FeignClient(contextId = "remoteLiuLiService",
        value = ServiceNameConstants.GATEWAY_SERVICE,
        fallbackFactory = RemoteLogicFallbackFactory.class)
public interface RemoteLiuLiService {
    /**
     * 获取客户端配置
     *
     * @param params 参数内容
     * @param source 请求来源
     * @return 结果
     */
    @PostMapping("/logic/getConfigByClientV2")
    R<Map<String, Object>> getConfigByClient(@RequestBody String params,
                                             @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 批量获取客户端配置
     *
     * @param params 参数内容
     * @param source 请求来源
     * @return 结果
     */
    @PostMapping("/logic/batchGetConfigByClient")
    R<Map<String, Object>> batchGetConfigByClient(@RequestBody String params,
                                                  @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 解析客户端配置
     *
     * @param params 参数内容
     * @param source 请求来源
     * @return 结果
     */
    @PostMapping("/logic/parseConfigByClientV2")
    R<Map<String, Object>> parseConfigByClient(@RequestBody String params,
                                               @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 上报应用错误日志
     *
     * @param params 参数内容
     * @param source 请求来源
     * @return 结果
     */
    @PostMapping("/logic/uploadErrorLog")
    R<Map<String, Object>> uploadErrorLog(@RequestBody String params,
                                          @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 上报应用心跳
     *
     * @param params 参数内容
     * @param source 请求来源
     * @return 结果
     */
    @PostMapping("/logic/uploadHeartBeat")
    R<Map<String, Object>> uploadHeartBeat(@RequestBody String params,
                                           @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 保存生产环境应用信息
     *
     * @param params 参数内容
     * @param source 请求来源
     * @return 结果
     */
    @PostMapping("/logic/saveApplicationInfo")
    R<Map<String, Object>> saveApplicationInfo(@RequestBody String params,
                                               @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 检查琉璃架构版本
     *
     * @param params 参数内容
     * @param source 请求来源
     * @return 结果
     */
    @PostMapping("/logic/checkV4Version")
    R<Map<String, Object>> checkV4Version(@RequestBody String params,
                                          @RequestHeader(SecurityConstants.FROM_SOURCE) String source);
}
