package com.af.v4.system.api;

import com.af.v4.system.api.domain.SysUser;
import com.af.v4.system.api.factory.RemoteUserFallbackFactory;
import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.constant.SecurityConstants;
import com.af.v4.system.common.core.constant.ServiceNameConstants;
import com.af.v4.system.common.core.domain.R;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * 用户服务
 */
@FeignClient(contextId = "remoteUserService", value = ServiceNameConstants.SYSTEM_SERVICE, fallbackFactory = RemoteUserFallbackFactory.class)
public interface RemoteUserService {
    /**
     * 通过用户名查询用户信息
     *
     * @param username 用户名
     * @param source   请求来源
     * @return 结果
     */
    @GetMapping("/user/info/{username}")
    R<LoginUser> getUserInfo(
            @PathVariable("username") String username,
            @RequestParam("resourceName") String resourceName,
            @RequestParam("isMobile") boolean isMobile,
            @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 通过微信openid查询用户信息
     *
     * @param openid 微信openid
     * @param source 请求来源
     * @return 结果
     */
    @GetMapping("/user/wxinfo/{openid}")
    R<LoginUser> getWxUserInfo(@PathVariable("openid") String openid, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 登出
     *
     * @param source 请求来源
     * @return 结果
     */
    @GetMapping("/user/logout")
    R<Map<String, Object>> logout(@RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 注册用户信息
     *
     * @param sysUser 用户信息
     * @param source  请求来源
     * @return 结果
     */
    @PostMapping("/user/register")
    R<Boolean> registerUserInfo(@RequestBody SysUser sysUser, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);
}
