package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.common.core.domain.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 实体服务降级处理
 */
@Component
public class RemoteEntityFallbackFactory implements FallbackFactory<RemoteEntityService> {
    private static final Logger log = LoggerFactory.getLogger(RemoteEntityFallbackFactory.class);

    @Override
    public RemoteEntityService create(Throwable throwable) {
        log.error("实体服务调用失败", throwable);
        return new RemoteEntityService() {
            @Override
            public R<Map<String, Object>> save(String serviceName, String entityName, String entity, String source) {
                return R.fail("保存/修改实体失败:" + throwable.getMessage());
            }

            @Override
            public R<List<Object>> saveBatch(String serviceName, String entityName, String entityContent, String source) {
                return R.fail("批量保存/修改实体失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> saveByKey(String serviceName, String entityName, String params, String source) {
                return R.fail("根据指定键保存实体失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> getById(String serviceName, String entityName, String id, String entity, String source) {
                return R.fail("根据ID获取实体失败:" + throwable.getMessage());
            }

            @Override
            public R<List<Object>> findAllByIds(String serviceName, String entityName, String entity, String source) {
                return R.fail("根据ID集合查询所有数据失败:" + throwable.getMessage());
            }

            @Override
            public R<List<Object>> findAll(String serviceName, String entityName, String entity, String source) {
                return R.fail("查询所有数据失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> getCount(String serviceName, String entityName, String source) {
                return R.fail("查询实体的总数量失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> deleteById(String serviceName, String entityName, String id, String source) {
                return R.fail("删除实体失败:" + throwable.getMessage());
            }

            @Override
            public R<Map<String, Object>> deleteAllByIds(String serviceName, String entityName, String entity, String source) {
                return R.fail("批量删除实体失败:" + throwable.getMessage());
            }
        };
    }
}
