package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.api.RemoteLogicService;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
public class DynamicFeignClientFactory<T> {

    private final FeignClientBuilder feignClientBuilder;

    private final Map<String, T> FEIGN_CLIENT_MAP = new HashMap<>();

    public DynamicFeignClientFactory(ApplicationContext appContext) {
        this.feignClientBuilder = new FeignClientBuilder(appContext);
    }

    public T getFeignClient(final Class<T> type, String serviceId) {
        String key = type.getName() + ":" + serviceId;
        T t = FEIGN_CLIENT_MAP.get(key);
        if (t == null) {
            synchronized (DynamicFeignClientFactory.class) {
                t = FEIGN_CLIENT_MAP.get(key);
                if (t == null) {
                    FeignClientFactoryBean feignClientFactoryBean = new FeignClientFactoryBean();
                    feignClientFactoryBean.setContextId(key);
                    if (type == RemoteLogicService.class) {
                        feignClientFactoryBean.setFallbackFactory(RemoteLogicFallbackFactory.class);
                    } else if (type == RemoteEntityService.class) {
                        feignClientFactoryBean.setFallbackFactory(RemoteEntityFallbackFactory.class);
                    }
                    t = this.feignClientBuilder.forType(type, feignClientFactoryBean, serviceId).build();
                    FEIGN_CLIENT_MAP.put(type.getName() + ":" + serviceId, t);
                }
            }
        }
        return t;
    }
}
