package com.af.v4.system.api;

import com.af.v4.system.api.factory.RemoteLogicFallbackFactory;
import com.af.v4.system.common.core.constant.SecurityConstants;
import com.af.v4.system.common.core.constant.ServiceNameConstants;
import com.af.v4.system.common.core.domain.R;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * 远程调用Logic服务
 *
 * @author Mr.river
 */
@FeignClient(contextId = "remoteLogicService",
        value = ServiceNameConstants.GATEWAY_SERVICE,
        fallbackFactory = RemoteLogicFallbackFactory.class)
public interface RemoteLogicService {
    /**
     * 远程执行logic
     *
     * @param serviceName 服务名称
     * @param logicName   logic名称
     * @param params      参数内容
     * @param source      请求来源
     * @return 结果
     */
    @PostMapping("/{serviceName}/logic/{logicName}")
    R<Object> run(@PathVariable("serviceName") String serviceName,
                  @PathVariable("logicName") String logicName,
                  @RequestBody String params,
                  @RequestHeader(SecurityConstants.FROM_SOURCE) String source);
}
