package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.common.core.domain.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 远程调用Logic服务降级处理
 *
 * @author Mr.river
 */
@Component
public class RemoteLogicFallbackFactory implements FallbackFactory<RemoteLogicService> {
    private static final Logger log = LoggerFactory.getLogger(RemoteLogicFallbackFactory.class);

    @Override
    public RemoteLogicService create(Throwable throwable) {
        log.error("Logic服务远程调用失败", throwable);
        return ((serviceName, logicName, params, source) ->
                R.fail("远程调用Logic失败:" + throwable.getMessage()));
    }
}
