package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.common.core.domain.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 实体服务降级处理
 */
@Component
public class RemoteEntityFallbackFactory implements FallbackFactory<RemoteEntityService> {
    private static final Logger log = LoggerFactory.getLogger(RemoteEntityFallbackFactory.class);

    @Override
    public RemoteEntityService create(Throwable throwable) {
        log.error("实体服务调用失败", throwable);
        return (entityName, row, source) -> R.fail("保存/修改实体失败:" + throwable.getMessage());
    }
}
