package com.af.v4.system.api;

import com.af.v4.system.api.factory.RemoteEntityFallbackFactory;
import com.af.v4.system.common.core.constant.SecurityConstants;
import com.af.v4.system.common.core.constant.ServiceNameConstants;
import com.af.v4.system.common.core.domain.R;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.Map;

/**
 * 实体服务
 *
 * @author Mr.river
 */
@FeignClient(contextId = "remoteEntityService", value = ServiceNameConstants.SYSTEM_SERVICE, fallbackFactory = RemoteEntityFallbackFactory.class)
public interface RemoteEntityService {
    /**
     * 实体保存
     *
     * @param entityName 实体名称
     * @param entity     实体内容
     * @param source     请求来源
     * @return 结果
     */
    @PostMapping(value = "/entity/{entityName}", produces = MediaType.APPLICATION_JSON_VALUE)
    R<Map<String, Object>> save(@PathVariable("entityName") String entityName,
                                @RequestBody String entity,
                                @RequestHeader(SecurityConstants.FROM_SOURCE) String source);
}
