package com.af.entity.ultils;


import org.json.JSONObject;
import org.w3c.dom.*;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.*;

/**
 * 扫描所有HBM的数据库映射文件
 * 并导出md文档
 */
public class scanHbmXmlToMD {
    private static final List<String> allXmlPath = new ArrayList<String>();
    public static final Map<String, Map<String, String>> allTableNameCommentMapping = new HashMap<>();

    private static final String basePath = "src/main/resources/entity/";

    // 存在HBM文件，但未在hibernate.cfg.xml中声明的，是否还导出md文件
    public static final boolean exportMDEvenHBMNotDeclare = false;

    // 输出目录
    public static final String exportFolder = "doc";

    // 上次导出日期：2024年5月16日，文件数394
    public static void main(String[] args) {
        // 删
        File docFolder = new File(exportFolder);
        File[] files = docFolder.listFiles();

        assert files != null;
        for (File file : files) {
            String name = file.getName();
            file.delete();
        }

        scanHbmFile();
    }


    private static void scanHbmFile() {
        File entityFolder = new File(basePath);
        findFileByFolder(entityFolder);


        int total = allXmlPath.size();
        System.out.println("===============================================");
        System.out.println("开始扫描  共发现[ " + total + " ]个配置");
//        for (int i = 0; i < 1; i++) {
        for (int i = 0; i < allXmlPath.size(); i++) {
            System.out.println("正在扫描.....当前进度 " + (i + 1) + " / " + total);
            scanHbm(allXmlPath.get(i)).toMD();
        }

        System.out.println("扫描配置完成！");
    }

    private static XMLProperties scanHbm(String path) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XMLProperties xmlProperties = new XMLProperties();
        String modalName = getModalNameFromPath(path);
        xmlProperties.setModalName(modalName);
        xmlProperties.setHbmPath(path);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(path);
            NodeList classList = document.getElementsByTagName("class");

            // 获取根节点，解析tableName 和 entityName
            Node head = classList.item(0);
            NamedNodeMap heardAttributes = head.getAttributes();
            String tableName = heardAttributes.getNamedItem("table").getTextContent();
            String entityName = heardAttributes.getNamedItem("entity-name").getTextContent();
            xmlProperties.setTableName(tableName);
            xmlProperties.setTableEntityName(entityName);

            // 解析子节点
            NodeList childNodeList = head.getChildNodes();
            for (int i = 0; i < childNodeList.getLength(); i++) {
                // 如果是备注和文字，跳过循环
                if (childNodeList.item(i).getNodeName().equals("#text") || childNodeList.item(i).getNodeName().equals("#comment")) {
                    continue;
                }
                Node childNode = childNodeList.item(i);
                NamedNodeMap childNodeAttributes = childNode.getAttributes();
                // 如果节点标签是id，证明是主键
                if (childNode.getNodeName().equals("id")) {
                    String pkName = childNodeAttributes.getNamedItem("name").getTextContent();
                    String pkType = childNodeAttributes.getNamedItem("type").getTextContent();
                    xmlProperties.setPKName(pkName);
                    xmlProperties.setPKType(pkType);

                    // 获取主键配置
                    NodeList nodeConfigList = childNode.getChildNodes();
                    for (int i1 = 0; i1 < nodeConfigList.getLength(); i1++) {
                        if (!nodeConfigList.item(i1).getNodeName().equals("#text") && !nodeConfigList.item(i1).getNodeName().equals("#comment")) {
                            Node item = nodeConfigList.item(i1);
                            if (item.getNodeName().equals("generator")) {
                                String generatorType = item.getAttributes().getNamedItem("class").getTextContent();
                                xmlProperties.setPKGenerator(generatorType);
                            }
                        }
                    }
                }else if (childNode.getNodeName().equals("property")) {
                    // 不是主键，则为属性节点
                    XMLColumnProperties xmlColumnProperties = new XMLColumnProperties();
                    NodeList nodeConfigList = childNode.getChildNodes();
                    String name = childNodeAttributes.getNamedItem("name").getTextContent();
                    String type = childNodeAttributes.getNamedItem("type").getTextContent();
                    xmlColumnProperties.setName(name);
                    xmlColumnProperties.setType(type);
                    for (int i1 = 0; i1 < nodeConfigList.getLength(); i1++) {
                        if (!nodeConfigList.item(i1).getNodeName().equals("#text") && !nodeConfigList.item(i1).getNodeName().equals("#comment")) {
                            Node item = nodeConfigList.item(i1);
                            if (item.getNodeName().equals("column")) {
                                String dbPropertiesName = item.getAttributes().getNamedItem("name").getTextContent();
                                xmlColumnProperties.setDBName(dbPropertiesName);
                            }
                            NodeList nodeSubConfigList = item.getChildNodes();
                            if (nodeSubConfigList.getLength() > 0) {
                                for (int i2 = 0; i2 < nodeSubConfigList.getLength(); i2++) {
                                    if (!nodeSubConfigList.item(i2).getNodeName().equals("#text") && !nodeSubConfigList.item(i2).getNodeName().equals("#comment")) {
                                        Node item1 = nodeSubConfigList.item(i2);
                                        if (item1.getNodeName().equals("comment")) {
                                            xmlColumnProperties.setComment(item1.getTextContent());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    List<XMLColumnProperties> columns = xmlProperties.getColumns();
                    columns.add(xmlColumnProperties);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

        return xmlProperties;
    }

    private static String getModalNameFromPath(String path) {
        int start = path.indexOf("af-");
        int end = path.indexOf("\\", start);
        return path.substring(start, end);
    }

    private static void findFileByFolder(File folder) {
        File[] files = folder.listFiles();
        assert files != null;
        for (File file : files) {
            if (file.isDirectory()) {
                findFileByFolder(file);
            } else {
                String fileName = file.getName();
                if (fileName.endsWith(".hbm.xml")) {
                    allXmlPath.add(file.getPath());
                }
                if (fileName.endsWith(".cfg.xml")) {
                    findAllTableComment(file.getPath());
                }
            }
        }
    }

    private static void findAllTableComment(String path) {
        String modalName = getModalNameFromPath(path);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Map<String,String> modalTableNameMapping = new HashMap<>();
        try {
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver() {
                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
            });
            Document document = db.parse(path);
            NodeList headNode = document.getElementsByTagName("session-factory");
            Node headItem = headNode.item(0);
            NodeList nodeList = headItem.getChildNodes();

            String tableNameComment = null;
            for (int i = 0; i < nodeList.getLength(); i++) {
                Node node = nodeList.item(i);
                if (node.getNodeName().startsWith("#comment")) {
                    tableNameComment = node.getTextContent();
                }else if (node.getNodeName().equals("mapping")){
                    String textContent = node.getAttributes().getNamedItem("resource").getTextContent();
                    String[] split = textContent.split("/");
                    String tableHbmName = split[split.length - 1];
                    if (tableNameComment != null) {
                        modalTableNameMapping.put(tableHbmName, tableNameComment);
                    }else {
                        modalTableNameMapping.put(tableHbmName, "无");
                    }
                    tableNameComment = null;
                }
            }


        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (allTableNameCommentMapping.containsKey(modalName)) {
            Map<String, String> origin = allTableNameCommentMapping.get(modalName);
            origin.putAll(modalTableNameMapping);
        } else {
            allTableNameCommentMapping.put(modalName, modalTableNameMapping);
        }
    }
}

class XMLProperties {
    private String tableName;
    private String hbmPath;
    private String tableEntityName;
    private String PKName;
    private String PKType;
    private String PKGenerator;
    private String modalName;
    private List<XMLColumnProperties> columns;

    @Override
    public String toString() {
        return "XMLProperties{" +
                "tableName='" + tableName + '\'' +
                ", tableEntityName='" + tableEntityName + '\'' +
                ", PKName='" + PKName + '\'' +
                ", PKType='" + PKType + '\'' +
                ", PKGenerator='" + PKGenerator + '\'' +
                ", columns=" + columns +
                '}';
    }

    public void toMD() {
        Map<String, String> tableCommentMap = scanHbmXmlToMD.allTableNameCommentMapping.get(modalName);
        int start = hbmPath.indexOf("hbm\\");
        String targetKey = hbmPath.substring(start + 4);
        String tableComment = "";
        if (tableCommentMap.containsKey(targetKey)) {
            tableComment = tableCommentMap.get(targetKey);
        } else {
            if (!scanHbmXmlToMD.exportMDEvenHBMNotDeclare) {
                return;
            }
        }


        StringBuilder sb = new StringBuilder();
        sb.append("# ").append(tableName).append("\n");
        sb.append("[HBM文件直达链接](/").append(hbmPath.replaceAll("\\\\", "/")).append(")");
        sb.append("\n");
        sb.append("> 表名备注：").append(tableComment).append("\n");
        sb.append(">\n");
        sb.append("> 实体名：").append(tableEntityName).append("\n");
        sb.append("\n");
        sb.append("## 主键\n");
        sb.append("> * 主键名：").append(PKName).append("\n");
        sb.append("> * 主键类型：").append(PKType).append("\n");
        sb.append("> * 主键生成策略：").append(PKGenerator).append("\n");
        sb.append("\n");

        sb.append("## 数据\n");
        sb.append("| 数据名 | 数据在数据库中列名 | 数据类型 | 备注 |\n");
        sb.append("| :----: | :----------------: | :------: | :--: |\n");
        sb.append("| ").append(PKName).append(" | ")
                .append(PKName).append(" | ").append(PKType).append(" | 主键 |\n");

        for (XMLColumnProperties properties : columns) {
            String name = properties.getName();
            String dbName = properties.getDBName();
            String type = properties.getType();
            String comment = properties.getComment();
            sb.append("| ").append(name).append(" | ")
                    .append(dbName).append(" | ").append(type).append(" | ").append(comment).append(" |\n");
        }

        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        FileWriter fileWriter = null;
        try {
            File file = new File(scanHbmXmlToMD.exportFolder + "/" + modalName + ".md");
            if (!file.exists()) {
                fileWriter = new FileWriter(scanHbmXmlToMD.exportFolder + "/" + modalName + ".md", false);
            } else {
                fileWriter = new FileWriter(scanHbmXmlToMD.exportFolder + "/" + modalName + ".md", true);
            }
            fileWriter.write(sb.toString());
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            try {
                assert fileWriter != null;
                fileWriter.flush();
                fileWriter.close();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public XMLProperties() {
        this.columns = new ArrayList<XMLColumnProperties>();
    }

    public String getTableName() {
        return tableName;
    }

    public String getModalName() {
        return modalName;
    }

    public String getHbmPath() {
        return hbmPath;
    }

    public void setHbmPath(String hbmPath) {
        this.hbmPath = hbmPath;
    }

    public void setModalName(String modalName) {
        this.modalName = modalName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableEntityName() {
        return tableEntityName;
    }

    public void setTableEntityName(String tableEntityName) {
        this.tableEntityName = tableEntityName;
    }

    public String getPKName() {
        return PKName;
    }

    public void setPKName(String PKName) {
        this.PKName = PKName;
    }

    public String getPKType() {
        return PKType;
    }

    public void setPKType(String PKType) {
        this.PKType = PKType;
    }

    public String getPKGenerator() {
        return PKGenerator;
    }

    public void setPKGenerator(String PKGenerator) {
        this.PKGenerator = PKGenerator;
    }

    public List<XMLColumnProperties> getColumns() {
        return columns;
    }

    public void setColumns(List<XMLColumnProperties> columns) {
        this.columns = columns;
    }
}

class XMLColumnProperties {
    private String name;
    private String DBName;
    private String type;
    private String comment;

    @Override
    public String toString() {
        return "XMLColumnProperties{" +
                "name='" + name + '\'' +
                ", DBName='" + DBName + '\'' +
                ", type='" + type + '\'' +
                ", comment='" + comment + '\'' +
                '}';
    }

    public XMLColumnProperties() {
    }

    public XMLColumnProperties(String name, String DBName, String type, String comment) {
        this.name = name;
        this.DBName = DBName;
        this.type = type;
        this.comment = comment;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDBName() {
        return DBName;
    }

    public void setDBName(String DBName) {
        this.DBName = DBName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}
