/*
 * Decompiled with CFR 0.152.
 */
package com.af.entity.ultils;

import com.af.entity.ultils.XMLColumnProperties;
import com.af.entity.ultils.XMLProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class scanHbmXmlToMD {
    private static final List<String> allXmlPath = new ArrayList<String>();
    public static final Map<String, Map<String, String>> allTableNameCommentMapping = new HashMap<String, Map<String, String>>();
    private static final String basePath = "src/main/resources/entity/";
    public static final boolean exportMDEvenHBMNotDeclare = false;
    public static final String exportFolder = "doc";

    public static void main(String[] args) {
        File docFolder = new File(exportFolder);
        File[] files = docFolder.listFiles();
        assert (files != null);
        for (File file : files) {
            String name = file.getName();
            file.delete();
        }
        scanHbmXmlToMD.scanHbmFile();
    }

    private static void scanHbmFile() {
        File entityFolder = new File(basePath);
        scanHbmXmlToMD.findFileByFolder(entityFolder);
        int total = allXmlPath.size();
        System.out.println("===============================================");
        System.out.println("\u5f00\u59cb\u626b\u63cf  \u5171\u53d1\u73b0[ " + total + " ]\u4e2a\u914d\u7f6e");
        for (int i = 0; i < allXmlPath.size(); ++i) {
            System.out.println("\u6b63\u5728\u626b\u63cf.....\u5f53\u524d\u8fdb\u5ea6 " + (i + 1) + " / " + total);
            scanHbmXmlToMD.scanHbm(allXmlPath.get(i)).toMD();
        }
        System.out.println("\u626b\u63cf\u914d\u7f6e\u5b8c\u6210\uff01");
    }

    private static XMLProperties scanHbm(String path) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XMLProperties xmlProperties = new XMLProperties();
        String modalName = scanHbmXmlToMD.getModalNameFromPath(path);
        xmlProperties.setModalName(modalName);
        xmlProperties.setHbmPath(path);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(path);
            NodeList classList = document.getElementsByTagName("class");
            Node head = classList.item(0);
            NamedNodeMap heardAttributes = head.getAttributes();
            String tableName = heardAttributes.getNamedItem("table").getTextContent();
            String entityName = heardAttributes.getNamedItem("entity-name").getTextContent();
            xmlProperties.setTableName(tableName);
            xmlProperties.setTableEntityName(entityName);
            NodeList childNodeList = head.getChildNodes();
            for (int i = 0; i < childNodeList.getLength(); ++i) {
                if (childNodeList.item(i).getNodeName().equals("#text") || childNodeList.item(i).getNodeName().equals("#comment")) continue;
                Node childNode = childNodeList.item(i);
                NamedNodeMap childNodeAttributes = childNode.getAttributes();
                if (childNode.getNodeName().equals("id")) {
                    String pkName = childNodeAttributes.getNamedItem("name").getTextContent();
                    String pkType = childNodeAttributes.getNamedItem("type").getTextContent();
                    xmlProperties.setPKName(pkName);
                    xmlProperties.setPKType(pkType);
                    NodeList nodeConfigList = childNode.getChildNodes();
                    for (int i1 = 0; i1 < nodeConfigList.getLength(); ++i1) {
                        Node item;
                        if (nodeConfigList.item(i1).getNodeName().equals("#text") || nodeConfigList.item(i1).getNodeName().equals("#comment") || !(item = nodeConfigList.item(i1)).getNodeName().equals("generator")) continue;
                        String generatorType = item.getAttributes().getNamedItem("class").getTextContent();
                        xmlProperties.setPKGenerator(generatorType);
                    }
                    continue;
                }
                if (!childNode.getNodeName().equals("property")) continue;
                XMLColumnProperties xmlColumnProperties = new XMLColumnProperties();
                NodeList nodeConfigList = childNode.getChildNodes();
                String name = childNodeAttributes.getNamedItem("name").getTextContent();
                String type = childNodeAttributes.getNamedItem("type").getTextContent();
                xmlColumnProperties.setName(name);
                xmlColumnProperties.setType(type);
                for (int i1 = 0; i1 < nodeConfigList.getLength(); ++i1) {
                    NodeList nodeSubConfigList;
                    if (nodeConfigList.item(i1).getNodeName().equals("#text") || nodeConfigList.item(i1).getNodeName().equals("#comment")) continue;
                    Node item = nodeConfigList.item(i1);
                    if (item.getNodeName().equals("column")) {
                        String dbPropertiesName = item.getAttributes().getNamedItem("name").getTextContent();
                        xmlColumnProperties.setDBName(dbPropertiesName);
                    }
                    if ((nodeSubConfigList = item.getChildNodes()).getLength() <= 0) continue;
                    for (int i2 = 0; i2 < nodeSubConfigList.getLength(); ++i2) {
                        Node item1;
                        if (nodeSubConfigList.item(i2).getNodeName().equals("#text") || nodeSubConfigList.item(i2).getNodeName().equals("#comment") || !(item1 = nodeSubConfigList.item(i2)).getNodeName().equals("comment")) continue;
                        xmlColumnProperties.setComment(item1.getTextContent());
                    }
                }
                List<XMLColumnProperties> columns = xmlProperties.getColumns();
                columns.add(xmlColumnProperties);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return xmlProperties;
    }

    private static String getModalNameFromPath(String path) {
        int start = path.indexOf("af-");
        int end = path.indexOf("\\", start);
        return path.substring(start, end);
    }

    private static void findFileByFolder(File folder) {
        File[] files = folder.listFiles();
        assert (files != null);
        for (File file : files) {
            if (file.isDirectory()) {
                scanHbmXmlToMD.findFileByFolder(file);
                continue;
            }
            String fileName = file.getName();
            if (fileName.endsWith(".hbm.xml")) {
                allXmlPath.add(file.getPath());
            }
            if (!fileName.endsWith(".cfg.xml")) continue;
            scanHbmXmlToMD.findAllTableComment(file.getPath());
        }
    }

    private static void findAllTableComment(String path) {
        String modalName = scanHbmXmlToMD.getModalNameFromPath(path);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        HashMap<String, String> modalTableNameMapping = new HashMap<String, String>();
        try {
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
            });
            Document document = db.parse(path);
            NodeList headNode = document.getElementsByTagName("session-factory");
            Node headItem = headNode.item(0);
            NodeList nodeList = headItem.getChildNodes();
            String tableNameComment = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeName().startsWith("#comment")) {
                    tableNameComment = node.getTextContent();
                    continue;
                }
                if (!node.getNodeName().equals("mapping")) continue;
                String textContent = node.getAttributes().getNamedItem("resource").getTextContent();
                String[] split = textContent.split("/");
                String tableHbmName = split[split.length - 1];
                if (tableNameComment != null) {
                    modalTableNameMapping.put(tableHbmName, tableNameComment);
                } else {
                    modalTableNameMapping.put(tableHbmName, "\u65e0");
                }
                tableNameComment = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (allTableNameCommentMapping.containsKey(modalName)) {
            Map<String, String> origin = allTableNameCommentMapping.get(modalName);
            origin.putAll(modalTableNameMapping);
        } else {
            allTableNameCommentMapping.put(modalName, modalTableNameMapping);
        }
    }
}

