package com.af.system.easyexcel.core;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelCommonException;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import static cn.hutool.core.lang.Console.log;

/**
 * @Description 导入监听
 * @Author Eraser
 */
@Slf4j
@NoArgsConstructor
public class DefautExcelListener<T> extends AnalysisEventListener<T> implements ExcelListener<T> {
    /**
     * 表头数据（存储所有的表头数据）
     */
    private Map<Integer, String> headMap;
    /**
     * 配置文件表头备注-字段数据
     */
    private Map<String, Object> columMap;
    /**
     * 是否Validator检验，默认为是
     */
    private Boolean isValidate = Boolean.TRUE;
    /**
     * 导入回执
     */
    private ExcelResult<T> excelResult;

    public DefautExcelListener(boolean isValidate, Map<String, Object> columMap) {
        this.excelResult = new DefautExcelResult<>();
        this.isValidate = isValidate;
        this.columMap = columMap;

    }

    /**
     * 这里会一行行的返回头
     *
     * @param headMap
     * @param context
     */
    @Override
    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        //存储全部表头数据
        this.headMap = headMap;
        //验证导入表头与系统表头是否对应
        Set<String> headList = columMap.keySet();
        for (String value : headMap.values()) {
            if (!headList.contains(value)) {
                throw new ExcelCommonException("表头数据无法匹配");
            }
        }
        log("解析到一条表头数据: {}", headMap.toString());

    }

    /**
     * 这个每一条数据解析都会来调用
     *
     * @param data
     * @param context
     */
    @Override
    public void invoke(T data, AnalysisContext context) {
        Map<Integer, Object> map = (Map<Integer, Object>) data;
        if (isValidate) {
            if (map.size() > columMap.size()) {
                excelResult.getErrorList().add("表格内容数据长度超出表头长度!");
                throw new ExcelCommonException("表格内容数据长度超出表头长度!");
            }
        }
        Map<String, Object> dataMap = new HashMap<>(map.size());
        map.forEach((k, v) -> {
            dataMap.put((columMap.get(headMap.get(k))).toString(), v);
        });
        log("解析到一条内容数据: {}", dataMap.toString());
        excelResult.getList().add(dataMap);

    }

    /**
     * 所有数据解析完成了 都会来调用
     *
     * @param context
     */
    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        // 这里也要保存数据，确保最后遗留的数据也存储到数据库
        log("所有数据解析完成！");
    }

    public Map<Integer, String> getHeadMap() {
        return headMap;
    }

    @Override
    public ExcelResult<T> getExcelResult() {
        return excelResult;
    }
}


